/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class PhysicsGeom!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEPHYSICSGEOMINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGPhysicsGeomBase.h"
#include "OSGPhysicsGeom.h"


OSG_USING_NAMESPACE

const OSG::BitVector  PhysicsGeomBase::BodyFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsGeomBase::BodyFieldId);

const OSG::BitVector  PhysicsGeomBase::PositionFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsGeomBase::PositionFieldId);

const OSG::BitVector  PhysicsGeomBase::RotationFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsGeomBase::RotationFieldId);

const OSG::BitVector  PhysicsGeomBase::QuaternionFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsGeomBase::QuaternionFieldId);

const OSG::BitVector  PhysicsGeomBase::CategoryBitsFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsGeomBase::CategoryBitsFieldId);

const OSG::BitVector  PhysicsGeomBase::CollideBitsFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsGeomBase::CollideBitsFieldId);

const OSG::BitVector  PhysicsGeomBase::SpaceFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsGeomBase::SpaceFieldId);

const OSG::BitVector  PhysicsGeomBase::EnableFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsGeomBase::EnableFieldId);

const OSG::BitVector PhysicsGeomBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var PhysicsBodyPtr  PhysicsGeomBase::_sfBody
    
*/
/*! \var Vec3f           PhysicsGeomBase::_sfPosition
    
*/
/*! \var Matrix          PhysicsGeomBase::_sfRotation
    
*/
/*! \var Quaternion      PhysicsGeomBase::_sfQuaternion
    
*/
/*! \var UInt64          PhysicsGeomBase::_sfCategoryBits
    
*/
/*! \var UInt64          PhysicsGeomBase::_sfCollideBits
    
*/
/*! \var PhysicsSpacePtr PhysicsGeomBase::_sfSpace
    
*/
/*! \var bool            PhysicsGeomBase::_sfEnable
    
*/

//! PhysicsGeom description

FieldDescription *PhysicsGeomBase::_desc[] = 
{
    new FieldDescription(SFPhysicsBodyPtr::getClassType(), 
                     "body", 
                     BodyFieldId, BodyFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsGeomBase::getSFBody),
    new FieldDescription(SFVec3f::getClassType(), 
                     "position", 
                     PositionFieldId, PositionFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsGeomBase::getSFPosition),
    new FieldDescription(SFMatrix::getClassType(), 
                     "rotation", 
                     RotationFieldId, RotationFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsGeomBase::getSFRotation),
    new FieldDescription(SFQuaternion::getClassType(), 
                     "quaternion", 
                     QuaternionFieldId, QuaternionFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsGeomBase::getSFQuaternion),
    new FieldDescription(SFUInt64::getClassType(), 
                     "categoryBits", 
                     CategoryBitsFieldId, CategoryBitsFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsGeomBase::getSFCategoryBits),
    new FieldDescription(SFUInt64::getClassType(), 
                     "collideBits", 
                     CollideBitsFieldId, CollideBitsFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsGeomBase::getSFCollideBits),
    new FieldDescription(SFPhysicsSpacePtr::getClassType(), 
                     "space", 
                     SpaceFieldId, SpaceFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsGeomBase::getSFSpace),
    new FieldDescription(SFBool::getClassType(), 
                     "enable", 
                     EnableFieldId, EnableFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsGeomBase::getSFEnable)
};


FieldContainerType PhysicsGeomBase::_type(
    "PhysicsGeom",
    "Attachment",
    NULL,
    (PrototypeCreateF) &PhysicsGeomBase::createEmpty,
    PhysicsGeom::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(PhysicsGeomBase, PhysicsGeomPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &PhysicsGeomBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &PhysicsGeomBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr PhysicsGeomBase::shallowCopy(void) const 
{ 
    PhysicsGeomPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const PhysicsGeom *>(this)); 

    return returnValue; 
}

UInt32 PhysicsGeomBase::getContainerSize(void) const 
{ 
    return sizeof(PhysicsGeom); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void PhysicsGeomBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((PhysicsGeomBase *) &other, whichField);
}
#else
void PhysicsGeomBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((PhysicsGeomBase *) &other, whichField, sInfo);
}
void PhysicsGeomBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void PhysicsGeomBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

PhysicsGeomBase::PhysicsGeomBase(void) :
    _sfBody                   (PhysicsBodyPtr(NullFC)), 
    _sfPosition               (), 
    _sfRotation               (), 
    _sfQuaternion             (), 
    _sfCategoryBits           (), 
    _sfCollideBits            (), 
    _sfSpace                  (PhysicsSpacePtr(NullFC)), 
    _sfEnable                 (bool(true)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

PhysicsGeomBase::PhysicsGeomBase(const PhysicsGeomBase &source) :
    _sfBody                   (source._sfBody                   ), 
    _sfPosition               (source._sfPosition               ), 
    _sfRotation               (source._sfRotation               ), 
    _sfQuaternion             (source._sfQuaternion             ), 
    _sfCategoryBits           (source._sfCategoryBits           ), 
    _sfCollideBits            (source._sfCollideBits            ), 
    _sfSpace                  (source._sfSpace                  ), 
    _sfEnable                 (source._sfEnable                 ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

PhysicsGeomBase::~PhysicsGeomBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 PhysicsGeomBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (BodyFieldMask & whichField))
    {
        returnValue += _sfBody.getBinSize();
    }

    if(FieldBits::NoField != (PositionFieldMask & whichField))
    {
        returnValue += _sfPosition.getBinSize();
    }

    if(FieldBits::NoField != (RotationFieldMask & whichField))
    {
        returnValue += _sfRotation.getBinSize();
    }

    if(FieldBits::NoField != (QuaternionFieldMask & whichField))
    {
        returnValue += _sfQuaternion.getBinSize();
    }

    if(FieldBits::NoField != (CategoryBitsFieldMask & whichField))
    {
        returnValue += _sfCategoryBits.getBinSize();
    }

    if(FieldBits::NoField != (CollideBitsFieldMask & whichField))
    {
        returnValue += _sfCollideBits.getBinSize();
    }

    if(FieldBits::NoField != (SpaceFieldMask & whichField))
    {
        returnValue += _sfSpace.getBinSize();
    }

    if(FieldBits::NoField != (EnableFieldMask & whichField))
    {
        returnValue += _sfEnable.getBinSize();
    }


    return returnValue;
}

void PhysicsGeomBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (BodyFieldMask & whichField))
    {
        _sfBody.copyToBin(pMem);
    }

    if(FieldBits::NoField != (PositionFieldMask & whichField))
    {
        _sfPosition.copyToBin(pMem);
    }

    if(FieldBits::NoField != (RotationFieldMask & whichField))
    {
        _sfRotation.copyToBin(pMem);
    }

    if(FieldBits::NoField != (QuaternionFieldMask & whichField))
    {
        _sfQuaternion.copyToBin(pMem);
    }

    if(FieldBits::NoField != (CategoryBitsFieldMask & whichField))
    {
        _sfCategoryBits.copyToBin(pMem);
    }

    if(FieldBits::NoField != (CollideBitsFieldMask & whichField))
    {
        _sfCollideBits.copyToBin(pMem);
    }

    if(FieldBits::NoField != (SpaceFieldMask & whichField))
    {
        _sfSpace.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnableFieldMask & whichField))
    {
        _sfEnable.copyToBin(pMem);
    }


}

void PhysicsGeomBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (BodyFieldMask & whichField))
    {
        _sfBody.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (PositionFieldMask & whichField))
    {
        _sfPosition.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (RotationFieldMask & whichField))
    {
        _sfRotation.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (QuaternionFieldMask & whichField))
    {
        _sfQuaternion.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (CategoryBitsFieldMask & whichField))
    {
        _sfCategoryBits.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (CollideBitsFieldMask & whichField))
    {
        _sfCollideBits.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (SpaceFieldMask & whichField))
    {
        _sfSpace.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnableFieldMask & whichField))
    {
        _sfEnable.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void PhysicsGeomBase::executeSyncImpl(      PhysicsGeomBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (BodyFieldMask & whichField))
        _sfBody.syncWith(pOther->_sfBody);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
        _sfPosition.syncWith(pOther->_sfPosition);

    if(FieldBits::NoField != (RotationFieldMask & whichField))
        _sfRotation.syncWith(pOther->_sfRotation);

    if(FieldBits::NoField != (QuaternionFieldMask & whichField))
        _sfQuaternion.syncWith(pOther->_sfQuaternion);

    if(FieldBits::NoField != (CategoryBitsFieldMask & whichField))
        _sfCategoryBits.syncWith(pOther->_sfCategoryBits);

    if(FieldBits::NoField != (CollideBitsFieldMask & whichField))
        _sfCollideBits.syncWith(pOther->_sfCollideBits);

    if(FieldBits::NoField != (SpaceFieldMask & whichField))
        _sfSpace.syncWith(pOther->_sfSpace);

    if(FieldBits::NoField != (EnableFieldMask & whichField))
        _sfEnable.syncWith(pOther->_sfEnable);


}
#else
void PhysicsGeomBase::executeSyncImpl(      PhysicsGeomBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (BodyFieldMask & whichField))
        _sfBody.syncWith(pOther->_sfBody);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
        _sfPosition.syncWith(pOther->_sfPosition);

    if(FieldBits::NoField != (RotationFieldMask & whichField))
        _sfRotation.syncWith(pOther->_sfRotation);

    if(FieldBits::NoField != (QuaternionFieldMask & whichField))
        _sfQuaternion.syncWith(pOther->_sfQuaternion);

    if(FieldBits::NoField != (CategoryBitsFieldMask & whichField))
        _sfCategoryBits.syncWith(pOther->_sfCategoryBits);

    if(FieldBits::NoField != (CollideBitsFieldMask & whichField))
        _sfCollideBits.syncWith(pOther->_sfCollideBits);

    if(FieldBits::NoField != (SpaceFieldMask & whichField))
        _sfSpace.syncWith(pOther->_sfSpace);

    if(FieldBits::NoField != (EnableFieldMask & whichField))
        _sfEnable.syncWith(pOther->_sfEnable);



}

void PhysicsGeomBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<PhysicsGeomPtr>::_type("PhysicsGeomPtr", "AttachmentPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(PhysicsGeomPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(PhysicsGeomPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGPhysicsGeomBase.cpp,v 1.2 2006/02/20 17:04:21 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGPHYSICSGEOMBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGPHYSICSGEOMBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGPHYSICSGEOMFIELDS_HEADER_CVSID;
}

