/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class PhysicsJoint!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &PhysicsJointBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 PhysicsJointBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
PhysicsJointPtr PhysicsJointBase::create(void) 
{
    PhysicsJointPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = PhysicsJointPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
PhysicsJointPtr PhysicsJointBase::createEmpty(void) 
{ 
    PhysicsJointPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the PhysicsJoint::_sfParam field.
inline
SFVec2f *PhysicsJointBase::getSFParam(void)
{
    return &_sfParam;
}

//! Get the PhysicsJoint::_sfWorld field.
inline
SFPhysicsWorldPtr *PhysicsJointBase::getSFWorld(void)
{
    return &_sfWorld;
}

//! Get the PhysicsJoint::_sfFirstBody field.
inline
SFPhysicsBodyPtr *PhysicsJointBase::getSFFirstBody(void)
{
    return &_sfFirstBody;
}

//! Get the PhysicsJoint::_sfSecondBody field.
inline
SFPhysicsBodyPtr *PhysicsJointBase::getSFSecondBody(void)
{
    return &_sfSecondBody;
}


//! Get the value of the PhysicsJoint::_sfParam field.
inline
Vec2f &PhysicsJointBase::getParam(void)
{
    return _sfParam.getValue();
}

//! Get the value of the PhysicsJoint::_sfParam field.
inline
const Vec2f &PhysicsJointBase::getParam(void) const
{
    return _sfParam.getValue();
}

//! Set the value of the PhysicsJoint::_sfParam field.
inline
void PhysicsJointBase::setParam(const Vec2f &value)
{
    _sfParam.setValue(value);
}

//! Get the value of the PhysicsJoint::_sfWorld field.
inline
PhysicsWorldPtr &PhysicsJointBase::getWorld(void)
{
    return _sfWorld.getValue();
}

//! Get the value of the PhysicsJoint::_sfWorld field.
inline
const PhysicsWorldPtr &PhysicsJointBase::getWorld(void) const
{
    return _sfWorld.getValue();
}

//! Set the value of the PhysicsJoint::_sfWorld field.
inline
void PhysicsJointBase::setWorld(const PhysicsWorldPtr &value)
{
    _sfWorld.setValue(value);
}

//! Get the value of the PhysicsJoint::_sfFirstBody field.
inline
PhysicsBodyPtr &PhysicsJointBase::getFirstBody(void)
{
    return _sfFirstBody.getValue();
}

//! Get the value of the PhysicsJoint::_sfFirstBody field.
inline
const PhysicsBodyPtr &PhysicsJointBase::getFirstBody(void) const
{
    return _sfFirstBody.getValue();
}

//! Set the value of the PhysicsJoint::_sfFirstBody field.
inline
void PhysicsJointBase::setFirstBody(const PhysicsBodyPtr &value)
{
    _sfFirstBody.setValue(value);
}

//! Get the value of the PhysicsJoint::_sfSecondBody field.
inline
PhysicsBodyPtr &PhysicsJointBase::getSecondBody(void)
{
    return _sfSecondBody.getValue();
}

//! Get the value of the PhysicsJoint::_sfSecondBody field.
inline
const PhysicsBodyPtr &PhysicsJointBase::getSecondBody(void) const
{
    return _sfSecondBody.getValue();
}

//! Set the value of the PhysicsJoint::_sfSecondBody field.
inline
void PhysicsJointBase::setSecondBody(const PhysicsBodyPtr &value)
{
    _sfSecondBody.setValue(value);
}


OSG_END_NAMESPACE

#define OSGPHYSICSJOINTBASE_INLINE_CVSID "@(#)$Id: OSGPhysicsJointBase.inl,v 1.2 2006/02/20 17:04:21 dirk Exp $"

