/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class PhysicsWorld
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGPHYSICSWORLDBASE_H_
#define _OSGPHYSICSWORLDBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGContribDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGAttachment.h> // Parent

#include <OSGReal32Fields.h> // Erp type
#include <OSGVec3fFields.h> // Gravity type
#include <OSGReal32Fields.h> // Cfm type
#include <OSGInt32Fields.h> // AutoDisableFlag type
#include <OSGReal32Fields.h> // AutoDisableLinearThreshold type
#include <OSGReal32Fields.h> // AutoDisableAngularThreshold type
#include <OSGInt32Fields.h> // AutoDisableSteps type
#include <OSGReal32Fields.h> // AutoDisableTime type
#include <OSGInt32Fields.h> // WorldQuickStepNumIterations type
#include <OSGReal32Fields.h> // WorldContactMaxCorrectingVel type
#include <OSGReal32Fields.h> // WorldContactSurfaceLayer type

#include <OSGPhysicsWorldFields.h>

OSG_BEGIN_NAMESPACE

class PhysicsWorld;
class BinaryDataHandler;

//! \brief PhysicsWorld Base Class.

class OSG_CONTRIBLIB_DLLMAPPING PhysicsWorldBase : public Attachment
{
  private:

    typedef Attachment    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef PhysicsWorldPtr  Ptr;

    enum
    {
        ErpFieldId                          = Inherited::NextFieldId,
        GravityFieldId                      = ErpFieldId                          + 1,
        CfmFieldId                          = GravityFieldId                      + 1,
        AutoDisableFlagFieldId              = CfmFieldId                          + 1,
        AutoDisableLinearThresholdFieldId   = AutoDisableFlagFieldId              + 1,
        AutoDisableAngularThresholdFieldId  = AutoDisableLinearThresholdFieldId   + 1,
        AutoDisableStepsFieldId             = AutoDisableAngularThresholdFieldId  + 1,
        AutoDisableTimeFieldId              = AutoDisableStepsFieldId             + 1,
        WorldQuickStepNumIterationsFieldId  = AutoDisableTimeFieldId              + 1,
        WorldContactMaxCorrectingVelFieldId = WorldQuickStepNumIterationsFieldId  + 1,
        WorldContactSurfaceLayerFieldId     = WorldContactMaxCorrectingVelFieldId + 1,
        NextFieldId                         = WorldContactSurfaceLayerFieldId     + 1
    };

    static const OSG::BitVector ErpFieldMask;
    static const OSG::BitVector GravityFieldMask;
    static const OSG::BitVector CfmFieldMask;
    static const OSG::BitVector AutoDisableFlagFieldMask;
    static const OSG::BitVector AutoDisableLinearThresholdFieldMask;
    static const OSG::BitVector AutoDisableAngularThresholdFieldMask;
    static const OSG::BitVector AutoDisableStepsFieldMask;
    static const OSG::BitVector AutoDisableTimeFieldMask;
    static const OSG::BitVector WorldQuickStepNumIterationsFieldMask;
    static const OSG::BitVector WorldContactMaxCorrectingVelFieldMask;
    static const OSG::BitVector WorldContactSurfaceLayerFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFReal32            *getSFErp            (void);
           SFVec3f             *getSFGravity        (void);
           SFReal32            *getSFCfm            (void);
           SFInt32             *getSFAutoDisableFlag(void);
           SFReal32            *getSFAutoDisableLinearThreshold(void);
           SFReal32            *getSFAutoDisableAngularThreshold(void);
           SFInt32             *getSFAutoDisableSteps(void);
           SFReal32            *getSFAutoDisableTime(void);
           SFInt32             *getSFWorldQuickStepNumIterations(void);
           SFReal32            *getSFWorldContactMaxCorrectingVel(void);
           SFReal32            *getSFWorldContactSurfaceLayer(void);

           Real32              &getErp            (void);
     const Real32              &getErp            (void) const;
           Vec3f               &getGravity        (void);
     const Vec3f               &getGravity        (void) const;
           Real32              &getCfm            (void);
     const Real32              &getCfm            (void) const;
           Int32               &getAutoDisableFlag(void);
     const Int32               &getAutoDisableFlag(void) const;
           Real32              &getAutoDisableLinearThreshold(void);
     const Real32              &getAutoDisableLinearThreshold(void) const;
           Real32              &getAutoDisableAngularThreshold(void);
     const Real32              &getAutoDisableAngularThreshold(void) const;
           Int32               &getAutoDisableSteps(void);
     const Int32               &getAutoDisableSteps(void) const;
           Real32              &getAutoDisableTime(void);
     const Real32              &getAutoDisableTime(void) const;
           Int32               &getWorldQuickStepNumIterations(void);
     const Int32               &getWorldQuickStepNumIterations(void) const;
           Real32              &getWorldContactMaxCorrectingVel(void);
     const Real32              &getWorldContactMaxCorrectingVel(void) const;
           Real32              &getWorldContactSurfaceLayer(void);
     const Real32              &getWorldContactSurfaceLayer(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setErp            ( const Real32 &value );
     void setGravity        ( const Vec3f &value );
     void setCfm            ( const Real32 &value );
     void setAutoDisableFlag( const Int32 &value );
     void setAutoDisableLinearThreshold( const Real32 &value );
     void setAutoDisableAngularThreshold( const Real32 &value );
     void setAutoDisableSteps( const Int32 &value );
     void setAutoDisableTime( const Real32 &value );
     void setWorldQuickStepNumIterations( const Int32 &value );
     void setWorldContactMaxCorrectingVel( const Real32 &value );
     void setWorldContactSurfaceLayer( const Real32 &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  PhysicsWorldPtr      create          (void); 
    static  PhysicsWorldPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFReal32            _sfErp;
    SFVec3f             _sfGravity;
    SFReal32            _sfCfm;
    SFInt32             _sfAutoDisableFlag;
    SFReal32            _sfAutoDisableLinearThreshold;
    SFReal32            _sfAutoDisableAngularThreshold;
    SFInt32             _sfAutoDisableSteps;
    SFReal32            _sfAutoDisableTime;
    SFInt32             _sfWorldQuickStepNumIterations;
    SFReal32            _sfWorldContactMaxCorrectingVel;
    SFReal32            _sfWorldContactSurfaceLayer;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    PhysicsWorldBase(void);
    PhysicsWorldBase(const PhysicsWorldBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~PhysicsWorldBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      PhysicsWorldBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      PhysicsWorldBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const PhysicsWorldBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef PhysicsWorldBase *PhysicsWorldBaseP;

typedef osgIF<PhysicsWorldBase::isNodeCore,
              CoredNodePtr<PhysicsWorld>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet PhysicsWorldNodePtr;

typedef RefPtr<PhysicsWorldPtr> PhysicsWorldRefPtr;

OSG_END_NAMESPACE

#define OSGPHYSICSWORLDBASE_HEADER_CVSID "@(#)$Id: OSGPhysicsWorldBase.h,v 1.2 2006/02/20 17:04:21 dirk Exp $"

#endif /* _OSGPHYSICSWORLDBASE_H_ */
