/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class Terrain!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &TerrainBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 TerrainBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
TerrainPtr TerrainBase::create(void) 
{
    TerrainPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = TerrainPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
TerrainPtr TerrainBase::createEmpty(void) 
{ 
    TerrainPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the Terrain::_sfHeightData field.
inline
SFImagePtr *TerrainBase::getSFHeightData(void)
{
    return &_sfHeightData;
}

//! Get the Terrain::_sfHeightScale field.
inline
SFReal32 *TerrainBase::getSFHeightScale(void)
{
    return &_sfHeightScale;
}

//! Get the Terrain::_mfHeightError field.
inline
MFReal32 *TerrainBase::getMFHeightError(void)
{
    return &_mfHeightError;
}

//! Get the Terrain::_mfHeightQuad field.
inline
MFReal32 *TerrainBase::getMFHeightQuad(void)
{
    return &_mfHeightQuad;
}

//! Get the Terrain::_sfWidth field.
inline
SFUInt32 *TerrainBase::getSFWidth(void)
{
    return &_sfWidth;
}

//! Get the Terrain::_sfLevel field.
inline
SFUInt32 *TerrainBase::getSFLevel(void)
{
    return &_sfLevel;
}

//! Get the Terrain::_sfDetail field.
inline
SFReal32 *TerrainBase::getSFDetail(void)
{
    return &_sfDetail;
}

//! Get the Terrain::_sfBorderDetail field.
inline
SFInt32 *TerrainBase::getSFBorderDetail(void)
{
    return &_sfBorderDetail;
}

//! Get the Terrain::_sfVertexSpacing field.
inline
SFReal32 *TerrainBase::getSFVertexSpacing(void)
{
    return &_sfVertexSpacing;
}

//! Get the Terrain::_sfHeightVertices field.
inline
SFGeoPositionsPtr *TerrainBase::getSFHeightVertices(void)
{
    return &_sfHeightVertices;
}

//! Get the Terrain::_sfGeoMorphing field.
inline
SFBool *TerrainBase::getSFGeoMorphing(void)
{
    return &_sfGeoMorphing;
}

//! Get the Terrain::_sfBoundMin field.
inline
SFPnt3f *TerrainBase::getSFBoundMin(void)
{
    return &_sfBoundMin;
}

//! Get the Terrain::_sfBoundMax field.
inline
SFPnt3f *TerrainBase::getSFBoundMax(void)
{
    return &_sfBoundMax;
}

//! Get the Terrain::_sfEyePoint field.
inline
SFPnt3f *TerrainBase::getSFEyePoint(void)
{
    return &_sfEyePoint;
}

//! Get the Terrain::_sfEyeHeight field.
inline
SFReal32 *TerrainBase::getSFEyeHeight(void)
{
    return &_sfEyeHeight;
}

//! Get the Terrain::_sfEyePointValid field.
inline
SFBool *TerrainBase::getSFEyePointValid(void)
{
    return &_sfEyePointValid;
}

//! Get the Terrain::_sfOriginX field.
inline
SFReal32 *TerrainBase::getSFOriginX(void)
{
    return &_sfOriginX;
}

//! Get the Terrain::_sfOriginY field.
inline
SFReal32 *TerrainBase::getSFOriginY(void)
{
    return &_sfOriginY;
}

//! Get the Terrain::_sfOriginTexX field.
inline
SFReal32 *TerrainBase::getSFOriginTexX(void)
{
    return &_sfOriginTexX;
}

//! Get the Terrain::_sfOriginTexY field.
inline
SFReal32 *TerrainBase::getSFOriginTexY(void)
{
    return &_sfOriginTexY;
}

//! Get the Terrain::_sfTexSpacing field.
inline
SFReal32 *TerrainBase::getSFTexSpacing(void)
{
    return &_sfTexSpacing;
}

//! Get the Terrain::_sfTexYSpacing field.
inline
SFReal32 *TerrainBase::getSFTexYSpacing(void)
{
    return &_sfTexYSpacing;
}

//! Get the Terrain::_sfUpdateTerrain field.
inline
SFBool *TerrainBase::getSFUpdateTerrain(void)
{
    return &_sfUpdateTerrain;
}

//! Get the Terrain::_sfPerPixelLighting field.
inline
SFBool *TerrainBase::getSFPerPixelLighting(void)
{
    return &_sfPerPixelLighting;
}


//! Get the value of the Terrain::_sfHeightData field.
inline
ImagePtr &TerrainBase::getHeightData(void)
{
    return _sfHeightData.getValue();
}

//! Get the value of the Terrain::_sfHeightData field.
inline
const ImagePtr &TerrainBase::getHeightData(void) const
{
    return _sfHeightData.getValue();
}

//! Set the value of the Terrain::_sfHeightData field.
inline
void TerrainBase::setHeightData(const ImagePtr &value)
{
    _sfHeightData.setValue(value);
}

//! Get the value of the Terrain::_sfHeightScale field.
inline
Real32 &TerrainBase::getHeightScale(void)
{
    return _sfHeightScale.getValue();
}

//! Get the value of the Terrain::_sfHeightScale field.
inline
const Real32 &TerrainBase::getHeightScale(void) const
{
    return _sfHeightScale.getValue();
}

//! Set the value of the Terrain::_sfHeightScale field.
inline
void TerrainBase::setHeightScale(const Real32 &value)
{
    _sfHeightScale.setValue(value);
}

//! Get the value of the Terrain::_sfWidth field.
inline
UInt32 &TerrainBase::getWidth(void)
{
    return _sfWidth.getValue();
}

//! Get the value of the Terrain::_sfWidth field.
inline
const UInt32 &TerrainBase::getWidth(void) const
{
    return _sfWidth.getValue();
}

//! Set the value of the Terrain::_sfWidth field.
inline
void TerrainBase::setWidth(const UInt32 &value)
{
    _sfWidth.setValue(value);
}

//! Get the value of the Terrain::_sfLevel field.
inline
UInt32 &TerrainBase::getLevel(void)
{
    return _sfLevel.getValue();
}

//! Get the value of the Terrain::_sfLevel field.
inline
const UInt32 &TerrainBase::getLevel(void) const
{
    return _sfLevel.getValue();
}

//! Set the value of the Terrain::_sfLevel field.
inline
void TerrainBase::setLevel(const UInt32 &value)
{
    _sfLevel.setValue(value);
}

//! Get the value of the Terrain::_sfDetail field.
inline
Real32 &TerrainBase::getDetail(void)
{
    return _sfDetail.getValue();
}

//! Get the value of the Terrain::_sfDetail field.
inline
const Real32 &TerrainBase::getDetail(void) const
{
    return _sfDetail.getValue();
}

//! Set the value of the Terrain::_sfDetail field.
inline
void TerrainBase::setDetail(const Real32 &value)
{
    _sfDetail.setValue(value);
}

//! Get the value of the Terrain::_sfBorderDetail field.
inline
Int32 &TerrainBase::getBorderDetail(void)
{
    return _sfBorderDetail.getValue();
}

//! Get the value of the Terrain::_sfBorderDetail field.
inline
const Int32 &TerrainBase::getBorderDetail(void) const
{
    return _sfBorderDetail.getValue();
}

//! Set the value of the Terrain::_sfBorderDetail field.
inline
void TerrainBase::setBorderDetail(const Int32 &value)
{
    _sfBorderDetail.setValue(value);
}

//! Get the value of the Terrain::_sfVertexSpacing field.
inline
Real32 &TerrainBase::getVertexSpacing(void)
{
    return _sfVertexSpacing.getValue();
}

//! Get the value of the Terrain::_sfVertexSpacing field.
inline
const Real32 &TerrainBase::getVertexSpacing(void) const
{
    return _sfVertexSpacing.getValue();
}

//! Set the value of the Terrain::_sfVertexSpacing field.
inline
void TerrainBase::setVertexSpacing(const Real32 &value)
{
    _sfVertexSpacing.setValue(value);
}

//! Get the value of the Terrain::_sfHeightVertices field.
inline
GeoPositionsPtr &TerrainBase::getHeightVertices(void)
{
    return _sfHeightVertices.getValue();
}

//! Get the value of the Terrain::_sfHeightVertices field.
inline
const GeoPositionsPtr &TerrainBase::getHeightVertices(void) const
{
    return _sfHeightVertices.getValue();
}

//! Set the value of the Terrain::_sfHeightVertices field.
inline
void TerrainBase::setHeightVertices(const GeoPositionsPtr &value)
{
    _sfHeightVertices.setValue(value);
}

//! Get the value of the Terrain::_sfGeoMorphing field.
inline
bool &TerrainBase::getGeoMorphing(void)
{
    return _sfGeoMorphing.getValue();
}

//! Get the value of the Terrain::_sfGeoMorphing field.
inline
const bool &TerrainBase::getGeoMorphing(void) const
{
    return _sfGeoMorphing.getValue();
}

//! Set the value of the Terrain::_sfGeoMorphing field.
inline
void TerrainBase::setGeoMorphing(const bool &value)
{
    _sfGeoMorphing.setValue(value);
}

//! Get the value of the Terrain::_sfBoundMin field.
inline
Pnt3f &TerrainBase::getBoundMin(void)
{
    return _sfBoundMin.getValue();
}

//! Get the value of the Terrain::_sfBoundMin field.
inline
const Pnt3f &TerrainBase::getBoundMin(void) const
{
    return _sfBoundMin.getValue();
}

//! Set the value of the Terrain::_sfBoundMin field.
inline
void TerrainBase::setBoundMin(const Pnt3f &value)
{
    _sfBoundMin.setValue(value);
}

//! Get the value of the Terrain::_sfBoundMax field.
inline
Pnt3f &TerrainBase::getBoundMax(void)
{
    return _sfBoundMax.getValue();
}

//! Get the value of the Terrain::_sfBoundMax field.
inline
const Pnt3f &TerrainBase::getBoundMax(void) const
{
    return _sfBoundMax.getValue();
}

//! Set the value of the Terrain::_sfBoundMax field.
inline
void TerrainBase::setBoundMax(const Pnt3f &value)
{
    _sfBoundMax.setValue(value);
}

//! Get the value of the Terrain::_sfEyePoint field.
inline
Pnt3f &TerrainBase::getEyePoint(void)
{
    return _sfEyePoint.getValue();
}

//! Get the value of the Terrain::_sfEyePoint field.
inline
const Pnt3f &TerrainBase::getEyePoint(void) const
{
    return _sfEyePoint.getValue();
}

//! Set the value of the Terrain::_sfEyePoint field.
inline
void TerrainBase::setEyePoint(const Pnt3f &value)
{
    _sfEyePoint.setValue(value);
}

//! Get the value of the Terrain::_sfEyeHeight field.
inline
Real32 &TerrainBase::getEyeHeight(void)
{
    return _sfEyeHeight.getValue();
}

//! Get the value of the Terrain::_sfEyeHeight field.
inline
const Real32 &TerrainBase::getEyeHeight(void) const
{
    return _sfEyeHeight.getValue();
}

//! Set the value of the Terrain::_sfEyeHeight field.
inline
void TerrainBase::setEyeHeight(const Real32 &value)
{
    _sfEyeHeight.setValue(value);
}

//! Get the value of the Terrain::_sfEyePointValid field.
inline
bool &TerrainBase::getEyePointValid(void)
{
    return _sfEyePointValid.getValue();
}

//! Get the value of the Terrain::_sfEyePointValid field.
inline
const bool &TerrainBase::getEyePointValid(void) const
{
    return _sfEyePointValid.getValue();
}

//! Set the value of the Terrain::_sfEyePointValid field.
inline
void TerrainBase::setEyePointValid(const bool &value)
{
    _sfEyePointValid.setValue(value);
}

//! Get the value of the Terrain::_sfOriginX field.
inline
Real32 &TerrainBase::getOriginX(void)
{
    return _sfOriginX.getValue();
}

//! Get the value of the Terrain::_sfOriginX field.
inline
const Real32 &TerrainBase::getOriginX(void) const
{
    return _sfOriginX.getValue();
}

//! Set the value of the Terrain::_sfOriginX field.
inline
void TerrainBase::setOriginX(const Real32 &value)
{
    _sfOriginX.setValue(value);
}

//! Get the value of the Terrain::_sfOriginY field.
inline
Real32 &TerrainBase::getOriginY(void)
{
    return _sfOriginY.getValue();
}

//! Get the value of the Terrain::_sfOriginY field.
inline
const Real32 &TerrainBase::getOriginY(void) const
{
    return _sfOriginY.getValue();
}

//! Set the value of the Terrain::_sfOriginY field.
inline
void TerrainBase::setOriginY(const Real32 &value)
{
    _sfOriginY.setValue(value);
}

//! Get the value of the Terrain::_sfOriginTexX field.
inline
Real32 &TerrainBase::getOriginTexX(void)
{
    return _sfOriginTexX.getValue();
}

//! Get the value of the Terrain::_sfOriginTexX field.
inline
const Real32 &TerrainBase::getOriginTexX(void) const
{
    return _sfOriginTexX.getValue();
}

//! Set the value of the Terrain::_sfOriginTexX field.
inline
void TerrainBase::setOriginTexX(const Real32 &value)
{
    _sfOriginTexX.setValue(value);
}

//! Get the value of the Terrain::_sfOriginTexY field.
inline
Real32 &TerrainBase::getOriginTexY(void)
{
    return _sfOriginTexY.getValue();
}

//! Get the value of the Terrain::_sfOriginTexY field.
inline
const Real32 &TerrainBase::getOriginTexY(void) const
{
    return _sfOriginTexY.getValue();
}

//! Set the value of the Terrain::_sfOriginTexY field.
inline
void TerrainBase::setOriginTexY(const Real32 &value)
{
    _sfOriginTexY.setValue(value);
}

//! Get the value of the Terrain::_sfTexSpacing field.
inline
Real32 &TerrainBase::getTexSpacing(void)
{
    return _sfTexSpacing.getValue();
}

//! Get the value of the Terrain::_sfTexSpacing field.
inline
const Real32 &TerrainBase::getTexSpacing(void) const
{
    return _sfTexSpacing.getValue();
}

//! Set the value of the Terrain::_sfTexSpacing field.
inline
void TerrainBase::setTexSpacing(const Real32 &value)
{
    _sfTexSpacing.setValue(value);
}

//! Get the value of the Terrain::_sfTexYSpacing field.
inline
Real32 &TerrainBase::getTexYSpacing(void)
{
    return _sfTexYSpacing.getValue();
}

//! Get the value of the Terrain::_sfTexYSpacing field.
inline
const Real32 &TerrainBase::getTexYSpacing(void) const
{
    return _sfTexYSpacing.getValue();
}

//! Set the value of the Terrain::_sfTexYSpacing field.
inline
void TerrainBase::setTexYSpacing(const Real32 &value)
{
    _sfTexYSpacing.setValue(value);
}

//! Get the value of the Terrain::_sfUpdateTerrain field.
inline
bool &TerrainBase::getUpdateTerrain(void)
{
    return _sfUpdateTerrain.getValue();
}

//! Get the value of the Terrain::_sfUpdateTerrain field.
inline
const bool &TerrainBase::getUpdateTerrain(void) const
{
    return _sfUpdateTerrain.getValue();
}

//! Set the value of the Terrain::_sfUpdateTerrain field.
inline
void TerrainBase::setUpdateTerrain(const bool &value)
{
    _sfUpdateTerrain.setValue(value);
}

//! Get the value of the Terrain::_sfPerPixelLighting field.
inline
bool &TerrainBase::getPerPixelLighting(void)
{
    return _sfPerPixelLighting.getValue();
}

//! Get the value of the Terrain::_sfPerPixelLighting field.
inline
const bool &TerrainBase::getPerPixelLighting(void) const
{
    return _sfPerPixelLighting.getValue();
}

//! Set the value of the Terrain::_sfPerPixelLighting field.
inline
void TerrainBase::setPerPixelLighting(const bool &value)
{
    _sfPerPixelLighting.setValue(value);
}


//! Get the value of the \a index element the Terrain::_mfHeightError field.
inline
Real32 &TerrainBase::getHeightError(const UInt32 index)
{
    return _mfHeightError[index];
}

//! Get the Terrain::_mfHeightError field.
inline
MFReal32 &TerrainBase::getHeightError(void)
{
    return _mfHeightError;
}

//! Get the Terrain::_mfHeightError field.
inline
const MFReal32 &TerrainBase::getHeightError(void) const
{
    return _mfHeightError;
}

//! Get the value of the \a index element the Terrain::_mfHeightQuad field.
inline
Real32 &TerrainBase::getHeightQuad(const UInt32 index)
{
    return _mfHeightQuad[index];
}

//! Get the Terrain::_mfHeightQuad field.
inline
MFReal32 &TerrainBase::getHeightQuad(void)
{
    return _mfHeightQuad;
}

//! Get the Terrain::_mfHeightQuad field.
inline
const MFReal32 &TerrainBase::getHeightQuad(void) const
{
    return _mfHeightQuad;
}

OSG_END_NAMESPACE

#define OSGTERRAINBASE_INLINE_CVSID "@(#)$Id: OSGTerrainBase.inl,v 1.6 2006/02/20 17:04:33 dirk Exp $"

