/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class IntersectActor
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


OSG_BEGIN_NAMESPACE

//----------------------------------------------------------------------------
//    State Access
//----------------------------------------------------------------------------

/*! Return the StatePtr, cast to this actor's state class
 *  IntersectActorBaseState
 */

inline const IntersectActorBase::IntersectActorBaseState *
IntersectActorBase::getCastState(void) const
{
    return reinterpret_cast<const IntersectActorBaseState *>(getState());
}

/*! Return the StatePtr, cast to this actor's state class
 *  IntersectActorBaseState
 */

inline IntersectActorBase::IntersectActorBaseState *
IntersectActorBase::getCastState(void)
{
    return reinterpret_cast<IntersectActorBaseState *>(getState());
}

//----------------------------------------------------------------------------
//    State Class
//----------------------------------------------------------------------------

/*! Default constructor.
 */

inline
IntersectActorBase::IntersectActorBaseState::IntersectActorBaseState(void) :
      _stateScaleFactor(1.0),
      _stateRay(),
      ParentStateType()
{
}

/*! Copy constructor.
 */

inline
IntersectActorBase::IntersectActorBaseState::IntersectActorBaseState(
    const IntersectActorBaseState &source) :
      _stateScaleFactor(source._stateScaleFactor),
      _stateRay(source._stateRay),
      ParentStateType(source)
{
}

/*! Return the state element ScaleFactor. For internal use only.
 */

inline const Real32 &
IntersectActorBase::IntersectActorBaseState::getScaleFactor(void) const
{
    return _stateScaleFactor;
}

/*! Return the state element ScaleFactor. For internal use only.
 */

inline Real32 &
IntersectActorBase::IntersectActorBaseState::getScaleFactor(void)
{
    return _stateScaleFactor;
}
/*! Return the state element Ray. For internal use only.
 */

inline const Line &
IntersectActorBase::IntersectActorBaseState::getRay(void) const
{
    return _stateRay;
}

/*! Return the state element Ray. For internal use only.
 */

inline Line &
IntersectActorBase::IntersectActorBaseState::getRay(void)
{
    return _stateRay;
}

//----------------------------------------------------------------------------
//    Public State Access
//----------------------------------------------------------------------------

/*! Return the state element HitDistance.
 */

inline const Real32 &
IntersectActorBase::getHitDistance(void) const
{
    return _stateHitDistance;
}

/*! Return the state element HitDistance.
 */

inline Real32 &
IntersectActorBase::getHitDistance(void)
{
    return _stateHitDistance;
}

/*! Set the state element HitDistance.
 */

inline void
IntersectActorBase::setHitDistance(const Real32 &stateVal)
{
    _stateHitDistance = stateVal;
}
/*! Return the state element Hit.
 */

inline const bool &
IntersectActorBase::getHit(void) const
{
    return _stateHit;
}

/*! Return the state element Hit.
 */

inline bool &
IntersectActorBase::getHit(void)
{
    return _stateHit;
}

/*! Set the state element Hit.
 */

inline void
IntersectActorBase::setHit(const bool &stateVal)
{
    _stateHit = stateVal;
}
/*! Return the state element HitObject.
 */

inline const NodePtr &
IntersectActorBase::getHitObject(void) const
{
    return _stateHitObject;
}

/*! Return the state element HitObject.
 */

inline NodePtr &
IntersectActorBase::getHitObject(void)
{
    return _stateHitObject;
}

/*! Set the state element HitObject.
 */

inline void
IntersectActorBase::setHitObject(const NodePtr &stateVal)
{
    _stateHitObject = stateVal;
}
/*! Return the state element HitTriangleIndex.
 */

inline const Int32 &
IntersectActorBase::getHitTriangleIndex(void) const
{
    return _stateHitTriangleIndex;
}

/*! Return the state element HitTriangleIndex.
 */

inline Int32 &
IntersectActorBase::getHitTriangleIndex(void)
{
    return _stateHitTriangleIndex;
}

/*! Set the state element HitTriangleIndex.
 */

inline void
IntersectActorBase::setHitTriangleIndex(const Int32 &stateVal)
{
    _stateHitTriangleIndex = stateVal;
}
/*! Return the state element HitNormal.
 */

inline const Vec3f &
IntersectActorBase::getHitNormal(void) const
{
    return _stateHitNormal;
}

/*! Return the state element HitNormal.
 */

inline Vec3f &
IntersectActorBase::getHitNormal(void)
{
    return _stateHitNormal;
}

/*! Set the state element HitNormal.
 */

inline void
IntersectActorBase::setHitNormal(const Vec3f &stateVal)
{
    _stateHitNormal = stateVal;
}
/*! Return the state element MaxDistance.
 */

inline const Real32 &
IntersectActorBase::getMaxDistance(void) const
{
    return _stateMaxDistance;
}

/*! Return the state element MaxDistance.
 */

inline Real32 &
IntersectActorBase::getMaxDistance(void)
{
    return _stateMaxDistance;
}

/*! Set the state element MaxDistance.
 */

inline void
IntersectActorBase::setMaxDistance(const Real32 &stateVal)
{
    _stateMaxDistance = stateVal;
}
/*! Return the state element ScaleFactor.
 *  \warning This state element can only be accessed after the actor was
 *  attached to an action.
 */

inline const Real32 &
IntersectActorBase::getScaleFactor(void) const
{
    return getCastState()->getScaleFactor();
}

/*! Return the state element ScaleFactor.
 *  \warning This state element can only be accessed after the actor was
 *  attached to an action.
 */

inline Real32 &
IntersectActorBase::getScaleFactor(void)
{
    return getCastState()->getScaleFactor();
}

/*! Set the state element ScaleFactor.
 *  \warning This state element can only be accessed after the actor was
 *  attached to an action.
 */

inline void
IntersectActorBase::setScaleFactor(const Real32 &stateVal)
{
    getCastState()->getScaleFactor() = stateVal;
}
/*! Return the state element Ray.
 *  \warning This state element can only be accessed after the actor was
 *  attached to an action.
 */

inline const Line &
IntersectActorBase::getRay(void) const
{
    return getCastState()->getRay();
}

/*! Return the state element Ray.
 *  \warning This state element can only be accessed after the actor was
 *  attached to an action.
 */

inline Line &
IntersectActorBase::getRay(void)
{
    return getCastState()->getRay();
}

/*! Set the state element Ray.
 *  \warning This state element can only be accessed after the actor was
 *  attached to an action.
 */

inline void
IntersectActorBase::setRay(const Line &stateVal)
{
    getCastState()->getRay() = stateVal;
}

//----------------------------------------------------------------------------
//    Protected State Access
//----------------------------------------------------------------------------


OSG_END_NAMESPACE

#define OSGINTERSECTACTORBASE_INLINE_CVSID "@(#)$Id: OSGIntersectActorBase.inl,v 1.6 2004/09/17 14:09:47 neumannc Exp $"
