/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class TestingExtendActor
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

//----------------------------------------------------------------------------
//    Includes
//----------------------------------------------------------------------------

#include <OSGConfig.h>
#include <OSGNodeCore.h>

#include "OSGTestingExtendActorBase.h"

OSG_USING_NAMESPACE

//----------------------------------------------------------------------------
//    Static Member Init
//----------------------------------------------------------------------------

TestingExtendActorBase::EnterStoreType *TestingExtendActorBase::_pClassEnterStore = NULL;
TestingExtendActorBase::LeaveStoreType *TestingExtendActorBase::_pClassLeaveStore = NULL;

//----------------------------------------------------------------------------
//    Destructor
//----------------------------------------------------------------------------

/*! Destructor.
 */

TestingExtendActorBase::~TestingExtendActorBase(void)
{
}

//----------------------------------------------------------------------------
//    Start/Stop
//----------------------------------------------------------------------------

/*! Called before a traversal begins. This method can be overridden in derived
 *  classes, but the inherited version must be called.
 */

TestingExtendActorBase::ResultE
TestingExtendActorBase::start(void)
{
    return ExtendActorBase::start();
}

/*! Called after a traversal ends. This method can be overridden in derived
 *  classes, but the inherited version must be called.
 */

TestingExtendActorBase::ResultE
TestingExtendActorBase::stop(void)
{
    return ExtendActorBase::stop();
}

//----------------------------------------------------------------------------
//    Enter/Leave
//----------------------------------------------------------------------------

/*! This method is called when a node is entered. This method can be overridden
 *  in derived classes, but the inherited version should be called if there is
 *  nothing to do for the node.
 */

TestingExtendActorBase::ResultE
TestingExtendActorBase::enterNode(FunctorArgumentType &funcArg)
{
    ResultE      result    = NewActionTypes::Continue;
    NodeCorePtr  pNodeCore = funcArg.getNode()->getCore();
    Functor     *pFunc     = NULL;

    if((pFunc = _instanceEnterStore.getFunctor(pNodeCore->getType())) != NULL)
    {
        result = pFunc->call(pNodeCore, funcArg);
    }
    else if((pFunc = _pClassEnterStore->getFunctor(pNodeCore->getType())) != NULL)
    {
        result = pFunc->call(pNodeCore, funcArg);
    }
    else
    {
        result = ExtendActorBase::enterNode(funcArg);
    }

    return result;
}

/*! This method is called when a node is left. This method can be overridden
 *  in derived classes, but the inherited version should be called if there is
 *  nothing to do for the node.
 */

TestingExtendActorBase::ResultE
TestingExtendActorBase::leaveNode(FunctorArgumentType &funcArg)
{
    ResultE      result    = NewActionTypes::Continue;
    NodeCorePtr  pNodeCore = funcArg.getNode()->getCore();
    Functor     *pFunc     = NULL;

    if((pFunc = _instanceLeaveStore.getFunctor(pNodeCore->getType())) != NULL)
    {
        result = pFunc->call(pNodeCore, funcArg);
    }
    else if((pFunc = _pClassLeaveStore->getFunctor(pNodeCore->getType())) != NULL)
    {
        result = pFunc->call(pNodeCore, funcArg);
    }
    else
    {
        result = ExtendActorBase::leaveNode(funcArg);
    }

    return result;
}

//----------------------------------------------------------------------------
//    Enter Registration
//----------------------------------------------------------------------------


/*! Register a functor that is used by all instances of this class, when
 *  entering a node with a core of the specified type.
 *  For every type of NodeCore a different functor can be registerd.
 */

void
TestingExtendActorBase::regClassEnter(const Functor            &refFunc,
                                 const FieldContainerType &refType )
{
    if(_pClassEnterStore == NULL)
        _pClassEnterStore = new EnterStoreType();

    _pClassEnterStore->regFunctor(refFunc, refType);
}

/*! Register a functor that is used by the instance of this class, when
 *  entering a node with a core of the specified type.
 *  For every type of NodeCore a different functor can be registerd.
 *  Instance functors take priority over class functors.
 */

void
TestingExtendActorBase::regEnter(const Functor            &refFunc,
                            const FieldContainerType &refType )
{
    _instanceEnterStore.regFunctor(refFunc, refType);
}

/*! Register a functor that is used by all instances of this class, when
 *  entering a node with a core for which no specific functor was registerd.
 */

void
TestingExtendActorBase::regDefaultClassEnter(const Functor &refFunc)
{
    if(_pClassEnterStore == NULL)
        _pClassEnterStore = new EnterStoreType();

    _pClassEnterStore->regDefaultFunctor(refFunc);
}

/*! Register a functor that is used by the instance of this class, when
 *  entering a node with a core for which no specific functor was registerd.
 *  Instance functors take priority over class functors.
 */

void
TestingExtendActorBase::regDefaultEnter(const Functor &refFunc)
{
    _instanceEnterStore.regDefaultFunctor(refFunc);
}

/*! Remove a functor registered with regClassEnter.
 */

void
TestingExtendActorBase::unregClassEnter(const FieldContainerType &refType)
{
    if(_pClassEnterStore == NULL)
        _pClassEnterStore = new EnterStoreType();

    _pClassEnterStore->unregFunctor(refType);
}

/*! Remove a functor registered with regEnter.
 */

void
TestingExtendActorBase::unregEnter(const FieldContainerType &refType)
{
    _instanceEnterStore.unregFunctor(refType);
}

/*! Remove the functor registered with regDefaultClassEnter.
 */

void
TestingExtendActorBase::unregDefaultClassEnter(void)
{
    if(_pClassEnterStore == NULL)
        _pClassEnterStore = new EnterStoreType();

    _pClassEnterStore->unregDefaultFunctor();
}

/*! Remove the functor registered with regDefaultEnter.
 */

void
TestingExtendActorBase::unregDefaultEnter(void)
{
    _instanceEnterStore.unregDefaultFunctor();
}

//----------------------------------------------------------------------------
//    Leave Registration
//----------------------------------------------------------------------------

/*! Register a functor that is used by all instances of this class, when
 *  leaveing a node with a core of the specified type.
 *  For every type of NodeCore a different functor can be registerd.
 */

void
TestingExtendActorBase::regClassLeave(const Functor            &refFunc,
                                 const FieldContainerType &refType )
{
    if(_pClassLeaveStore == NULL)
        _pClassLeaveStore = new LeaveStoreType();

    _pClassLeaveStore->regFunctor(refFunc, refType);
}

/*! Register a functor that is used by the instance of this class, when
 *  leaveing a node with a core of the specified type.
 *  For every type of NodeCore a different functor can be registerd.
 *  Instance functors take priority over class functors.
 */

void
TestingExtendActorBase::regLeave(const Functor            &refFunc,
                            const FieldContainerType &refType )
{
    _instanceLeaveStore.regFunctor(refFunc, refType);
}

/*! Register a functor that is used by all instances of this class, when
 *  leaveing a node with a core for which no specific functor was registerd.
 */

void
TestingExtendActorBase::regDefaultClassLeave(const Functor &refFunc)
{
    if(_pClassLeaveStore == NULL)
        _pClassLeaveStore = new LeaveStoreType();

    _pClassLeaveStore->regDefaultFunctor(refFunc);
}

/*! Register a functor that is used by the instance of this class, when
 *  leaveing a node with a core for which no specific functor was registerd.
 *  Instance functors take priority over class functors.
 */

void
TestingExtendActorBase::regDefaultLeave(const Functor &refFunc)
{
    _instanceLeaveStore.regDefaultFunctor(refFunc);
}

/*! Remove a functor registered with regClassLeave.
 */

void
TestingExtendActorBase::unregClassLeave(const FieldContainerType &refType)
{
    if(_pClassLeaveStore == NULL)
        _pClassLeaveStore = new LeaveStoreType();

    _pClassLeaveStore->unregFunctor(refType);
}

/*! Remove a functor registered with regLeave.
 */

void
TestingExtendActorBase::unregLeave(const FieldContainerType &refType)
{
    _instanceLeaveStore.unregFunctor(refType);
}

/*! Remove the functor registered with regDefaultClassLeave.
 */

void
TestingExtendActorBase::unregDefaultClassLeave(void)
{
    if(_pClassLeaveStore == NULL)
        _pClassLeaveStore = new LeaveStoreType();

    _pClassLeaveStore->unregDefaultFunctor();
}

/*! Remove the functor registered with regDefaultLeave.
 */

void
TestingExtendActorBase::unregDefaultLeave(void)
{
    _instanceLeaveStore.unregDefaultFunctor();
}

//----------------------------------------------------------------------------
//    State Management
//----------------------------------------------------------------------------

#ifdef OSG_NEWACTION_STATESLOTINTERFACE

UInt32
TestingExtendActorBase::createStateClone(void)
{
    UInt32     stateSlot = getSlotMap   (               ).size();
    StateType *pClone    = new StateType(*getCastState());

    getSlotMap().push_back(pClone);

    setState(pClone);

    return stateSlot;
}

#else /* OSG_NEWACTION_STATESLOTINTERFACE */

TestingExtendActorBase::ActorBaseState *
TestingExtendActorBase::createStateClone(void)
{
    StateType *pClone = new StateType(*getCastState());

    setState(pClone);

    return pClone;
}

#endif /* OSG_NEWACTION_STATESLOTINTERFACE */

#ifdef OSG_NEWACTION_STATESLOTINTERFACE

void
TestingExtendActorBase::destroyStateClone(UInt32 slotId)
{
    delete getSlotMap()[slotId];
}

#else /* OSG_NEWACTION_STATESLOTINTERFACE */

void
TestingExtendActorBase::destroyStateClone(ActorBaseState *pState)
{
    delete pState;
}

#endif /* OSG_NEWACTION_STATESLOTINTERFACE */

void
TestingExtendActorBase::createInitialState(void)
{
    if(getState() != NULL)
    {
        SWARNING << "TestingExtendActorBase::createInitialState: State is not NULL."
                 << endLog;
    }

    setState(new StateType());
}

void
TestingExtendActorBase::deleteInitialState(void)
{
    if(getState() == NULL)
    {
        SWARNING << "TestingExtendActorBase::deleteInitalState: State is NULL."
                 << endLog;
    }

    delete getState();

    setState(NULL);
}


//----------------------------------------------------------------------------
//    State Class
//----------------------------------------------------------------------------

/*! Destructor.
 */

TestingExtendActorBase::TestingExtendActorBaseState::~TestingExtendActorBaseState(void)
{
}

//----------------------------------------------------------------------------
//    Constructors
//----------------------------------------------------------------------------

/*! Default Constructor.
 */

TestingExtendActorBase::TestingExtendActorBase(void)
    : Inherited(),
      _instanceEnterStore(),
      _instanceLeaveStore()
{
    if(_pClassEnterStore == NULL)
        _pClassEnterStore = new EnterStoreType();

    if(_pClassLeaveStore == NULL)
        _pClassLeaveStore = new LeaveStoreType();

    setEnterNodeFlag(true);
    setLeaveNodeFlag(true);
}

//----------------------------------------------------------------------------
//    Event Notification
//----------------------------------------------------------------------------

/*! Called when the actor is attached to an action. This method can
 *  be overridden in derived classes, but the inherited version must be called.
 */

void
TestingExtendActorBase::addEvent(NewActionBase *pAction, UInt32 uiActorId)
{
    Inherited::addEvent(pAction, uiActorId);
}

/*! Called when the actor is detached from an action. This method can
 *  be overridden in derived classes, but the inherited version must be called.
 */

void
TestingExtendActorBase::subEvent(NewActionBase *pAction, UInt32 uiActorId)
{
    Inherited::subEvent(pAction, uiActorId);
}

/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning(disable : 177)
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGTestingExtendActorBase.cpp,v 1.1 2004/09/17 14:09:47 neumannc Exp $";
    static Char8 cvsid_hpp       [] = OSGTESTINGEXTENDACTORBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGTESTINGEXTENDACTORBASE_INLINE_CVSID;
}

#ifdef OSG_LINUX_ICC
#pragma warning(enable : 177)
#endif

#ifdef OSG_SGI_CC
#pragma reset woff 1174
#endif
