/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class PipelineComposer!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEPIPELINECOMPOSERINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGPipelineComposerBase.h"
#include "OSGPipelineComposer.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  PipelineComposerBase::ShortFieldMask = 
    (TypeTraits<BitVector>::One << PipelineComposerBase::ShortFieldId);

const OSG::BitVector  PipelineComposerBase::AlphaFieldMask = 
    (TypeTraits<BitVector>::One << PipelineComposerBase::AlphaFieldId);

const OSG::BitVector  PipelineComposerBase::TileSizeFieldMask = 
    (TypeTraits<BitVector>::One << PipelineComposerBase::TileSizeFieldId);

const OSG::BitVector  PipelineComposerBase::PipelinedFieldMask = 
    (TypeTraits<BitVector>::One << PipelineComposerBase::PipelinedFieldId);

const OSG::BitVector PipelineComposerBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var bool            PipelineComposerBase::_sfShort
    
*/
/*! \var bool            PipelineComposerBase::_sfAlpha
    
*/
/*! \var UInt32          PipelineComposerBase::_sfTileSize
    
*/
/*! \var bool            PipelineComposerBase::_sfPipelined
    
*/

//! PipelineComposer description

FieldDescription *PipelineComposerBase::_desc[] = 
{
    new FieldDescription(SFBool::getClassType(), 
                     "short", 
                     ShortFieldId, ShortFieldMask,
                     false,
                     (FieldAccessMethod) &PipelineComposerBase::getSFShort),
    new FieldDescription(SFBool::getClassType(), 
                     "alpha", 
                     AlphaFieldId, AlphaFieldMask,
                     false,
                     (FieldAccessMethod) &PipelineComposerBase::getSFAlpha),
    new FieldDescription(SFUInt32::getClassType(), 
                     "tileSize", 
                     TileSizeFieldId, TileSizeFieldMask,
                     false,
                     (FieldAccessMethod) &PipelineComposerBase::getSFTileSize),
    new FieldDescription(SFBool::getClassType(), 
                     "pipelined", 
                     PipelinedFieldId, PipelinedFieldMask,
                     false,
                     (FieldAccessMethod) &PipelineComposerBase::getSFPipelined)
};


FieldContainerType PipelineComposerBase::_type(
    "PipelineComposer",
    "ImageComposer",
    NULL,
    (PrototypeCreateF) &PipelineComposerBase::createEmpty,
    PipelineComposer::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(PipelineComposerBase, PipelineComposerPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &PipelineComposerBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &PipelineComposerBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr PipelineComposerBase::shallowCopy(void) const 
{ 
    PipelineComposerPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const PipelineComposer *>(this)); 

    return returnValue; 
}

UInt32 PipelineComposerBase::getContainerSize(void) const 
{ 
    return sizeof(PipelineComposer); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void PipelineComposerBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((PipelineComposerBase *) &other, whichField);
}
#else
void PipelineComposerBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((PipelineComposerBase *) &other, whichField, sInfo);
}
void PipelineComposerBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void PipelineComposerBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

PipelineComposerBase::PipelineComposerBase(void) :
    _sfShort                  (bool(true)), 
    _sfAlpha                  (bool(false)), 
    _sfTileSize               (UInt32(44)), 
    _sfPipelined              (bool(false)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

PipelineComposerBase::PipelineComposerBase(const PipelineComposerBase &source) :
    _sfShort                  (source._sfShort                  ), 
    _sfAlpha                  (source._sfAlpha                  ), 
    _sfTileSize               (source._sfTileSize               ), 
    _sfPipelined              (source._sfPipelined              ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

PipelineComposerBase::~PipelineComposerBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 PipelineComposerBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ShortFieldMask & whichField))
    {
        returnValue += _sfShort.getBinSize();
    }

    if(FieldBits::NoField != (AlphaFieldMask & whichField))
    {
        returnValue += _sfAlpha.getBinSize();
    }

    if(FieldBits::NoField != (TileSizeFieldMask & whichField))
    {
        returnValue += _sfTileSize.getBinSize();
    }

    if(FieldBits::NoField != (PipelinedFieldMask & whichField))
    {
        returnValue += _sfPipelined.getBinSize();
    }


    return returnValue;
}

void PipelineComposerBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ShortFieldMask & whichField))
    {
        _sfShort.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AlphaFieldMask & whichField))
    {
        _sfAlpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TileSizeFieldMask & whichField))
    {
        _sfTileSize.copyToBin(pMem);
    }

    if(FieldBits::NoField != (PipelinedFieldMask & whichField))
    {
        _sfPipelined.copyToBin(pMem);
    }


}

void PipelineComposerBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ShortFieldMask & whichField))
    {
        _sfShort.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AlphaFieldMask & whichField))
    {
        _sfAlpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TileSizeFieldMask & whichField))
    {
        _sfTileSize.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (PipelinedFieldMask & whichField))
    {
        _sfPipelined.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void PipelineComposerBase::executeSyncImpl(      PipelineComposerBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ShortFieldMask & whichField))
        _sfShort.syncWith(pOther->_sfShort);

    if(FieldBits::NoField != (AlphaFieldMask & whichField))
        _sfAlpha.syncWith(pOther->_sfAlpha);

    if(FieldBits::NoField != (TileSizeFieldMask & whichField))
        _sfTileSize.syncWith(pOther->_sfTileSize);

    if(FieldBits::NoField != (PipelinedFieldMask & whichField))
        _sfPipelined.syncWith(pOther->_sfPipelined);


}
#else
void PipelineComposerBase::executeSyncImpl(      PipelineComposerBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (ShortFieldMask & whichField))
        _sfShort.syncWith(pOther->_sfShort);

    if(FieldBits::NoField != (AlphaFieldMask & whichField))
        _sfAlpha.syncWith(pOther->_sfAlpha);

    if(FieldBits::NoField != (TileSizeFieldMask & whichField))
        _sfTileSize.syncWith(pOther->_sfTileSize);

    if(FieldBits::NoField != (PipelinedFieldMask & whichField))
        _sfPipelined.syncWith(pOther->_sfPipelined);



}

void PipelineComposerBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<PipelineComposerPtr>::_type("PipelineComposerPtr", "ImageComposerPtr");
#endif



/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.46 2006/03/16 17:01:53 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGPIPELINECOMPOSERBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGPIPELINECOMPOSERBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGPIPELINECOMPOSERFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

