/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class SimpleMaterial
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGSIMPLEMATERIALBASE_H_
#define _OSGSIMPLEMATERIALBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGSystemDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGChunkMaterial.h> // Parent

#include <OSGColor3fFields.h> // Ambient type
#include <OSGColor3fFields.h> // Diffuse type
#include <OSGColor3fFields.h> // Specular type
#include <OSGReal32Fields.h> // Shininess type
#include <OSGColor3fFields.h> // Emission type
#include <OSGReal32Fields.h> // Transparency type
#include <OSGBoolFields.h> // Lit type
#include <OSGGLenumFields.h> // ColorMaterial type

#include <OSGSimpleMaterialFields.h>

OSG_BEGIN_NAMESPACE

class SimpleMaterial;
class BinaryDataHandler;

//! \brief SimpleMaterial Base Class.

class OSG_SYSTEMLIB_DLLMAPPING SimpleMaterialBase : public ChunkMaterial
{
  private:

    typedef ChunkMaterial    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef SimpleMaterialPtr  Ptr;

    enum
    {
        AmbientFieldId       = Inherited::NextFieldId,
        DiffuseFieldId       = AmbientFieldId       + 1,
        SpecularFieldId      = DiffuseFieldId       + 1,
        ShininessFieldId     = SpecularFieldId      + 1,
        EmissionFieldId      = ShininessFieldId     + 1,
        TransparencyFieldId  = EmissionFieldId      + 1,
        LitFieldId           = TransparencyFieldId  + 1,
        ColorMaterialFieldId = LitFieldId           + 1,
        NextFieldId          = ColorMaterialFieldId + 1
    };

    static const OSG::BitVector AmbientFieldMask;
    static const OSG::BitVector DiffuseFieldMask;
    static const OSG::BitVector SpecularFieldMask;
    static const OSG::BitVector ShininessFieldMask;
    static const OSG::BitVector EmissionFieldMask;
    static const OSG::BitVector TransparencyFieldMask;
    static const OSG::BitVector LitFieldMask;
    static const OSG::BitVector ColorMaterialFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFColor3f           *getSFAmbient        (void);
           SFColor3f           *getSFDiffuse        (void);
           SFColor3f           *getSFSpecular       (void);
           SFReal32            *getSFShininess      (void);
           SFColor3f           *getSFEmission       (void);
           SFReal32            *getSFTransparency   (void);
           SFBool              *getSFLit            (void);
           SFGLenum            *getSFColorMaterial  (void);

           Color3f             &getAmbient        (void);
     const Color3f             &getAmbient        (void) const;
           Color3f             &getDiffuse        (void);
     const Color3f             &getDiffuse        (void) const;
           Color3f             &getSpecular       (void);
     const Color3f             &getSpecular       (void) const;
           Real32              &getShininess      (void);
     const Real32              &getShininess      (void) const;
           Color3f             &getEmission       (void);
     const Color3f             &getEmission       (void) const;
           Real32              &getTransparency   (void);
     const Real32              &getTransparency   (void) const;
           bool                &getLit            (void);
     const bool                &getLit            (void) const;
           GLenum              &getColorMaterial  (void);
     const GLenum              &getColorMaterial  (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setAmbient        ( const Color3f &value );
     void setDiffuse        ( const Color3f &value );
     void setSpecular       ( const Color3f &value );
     void setShininess      ( const Real32 &value );
     void setEmission       ( const Color3f &value );
     void setTransparency   ( const Real32 &value );
     void setLit            ( const bool &value );
     void setColorMaterial  ( const GLenum &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  SimpleMaterialPtr      create          (void); 
    static  SimpleMaterialPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFColor3f           _sfAmbient;
    SFColor3f           _sfDiffuse;
    SFColor3f           _sfSpecular;
    SFReal32            _sfShininess;
    SFColor3f           _sfEmission;
    SFReal32            _sfTransparency;
    SFBool              _sfLit;
    SFGLenum            _sfColorMaterial;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    SimpleMaterialBase(void);
    SimpleMaterialBase(const SimpleMaterialBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~SimpleMaterialBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      SimpleMaterialBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      SimpleMaterialBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const SimpleMaterialBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef SimpleMaterialBase *SimpleMaterialBaseP;

typedef osgIF<SimpleMaterialBase::isNodeCore,
              CoredNodePtr<SimpleMaterial>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet SimpleMaterialNodePtr;

typedef RefPtr<SimpleMaterialPtr> SimpleMaterialRefPtr;

OSG_END_NAMESPACE

#define OSGSIMPLEMATERIALBASE_HEADER_CVSID "@(#)$Id: FCBaseTemplate_h.h,v 1.40 2005/07/20 00:10:14 vossg Exp $"

#endif /* _OSGSIMPLEMATERIALBASE_H_ */
