/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class Billboard!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &BillboardBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 BillboardBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
BillboardPtr BillboardBase::create(void) 
{
    BillboardPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = BillboardPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
BillboardPtr BillboardBase::createEmpty(void) 
{ 
    BillboardPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the Billboard::_sfAxisOfRotation field.
inline
SFVec3f *BillboardBase::getSFAxisOfRotation(void)
{
    return &_sfAxisOfRotation;
}

//! Get the Billboard::_sfFocusOnCamera field.
inline
SFBool *BillboardBase::getSFFocusOnCamera(void)
{
    return &_sfFocusOnCamera;
}

//! Get the Billboard::_sfAlignToScreen field.
inline
SFBool *BillboardBase::getSFAlignToScreen(void)
{
    return &_sfAlignToScreen;
}

//! Get the Billboard::_sfMinAngle field.
inline
SFReal32 *BillboardBase::getSFMinAngle(void)
{
    return &_sfMinAngle;
}

//! Get the Billboard::_sfMaxAngle field.
inline
SFReal32 *BillboardBase::getSFMaxAngle(void)
{
    return &_sfMaxAngle;
}


//! Get the value of the Billboard::_sfAxisOfRotation field.
inline
Vec3f &BillboardBase::getAxisOfRotation(void)
{
    return _sfAxisOfRotation.getValue();
}

//! Get the value of the Billboard::_sfAxisOfRotation field.
inline
const Vec3f &BillboardBase::getAxisOfRotation(void) const
{
    return _sfAxisOfRotation.getValue();
}

//! Set the value of the Billboard::_sfAxisOfRotation field.
inline
void BillboardBase::setAxisOfRotation(const Vec3f &value)
{
    _sfAxisOfRotation.setValue(value);
}

//! Get the value of the Billboard::_sfFocusOnCamera field.
inline
bool &BillboardBase::getFocusOnCamera(void)
{
    return _sfFocusOnCamera.getValue();
}

//! Get the value of the Billboard::_sfFocusOnCamera field.
inline
const bool &BillboardBase::getFocusOnCamera(void) const
{
    return _sfFocusOnCamera.getValue();
}

//! Set the value of the Billboard::_sfFocusOnCamera field.
inline
void BillboardBase::setFocusOnCamera(const bool &value)
{
    _sfFocusOnCamera.setValue(value);
}

//! Get the value of the Billboard::_sfAlignToScreen field.
inline
bool &BillboardBase::getAlignToScreen(void)
{
    return _sfAlignToScreen.getValue();
}

//! Get the value of the Billboard::_sfAlignToScreen field.
inline
const bool &BillboardBase::getAlignToScreen(void) const
{
    return _sfAlignToScreen.getValue();
}

//! Set the value of the Billboard::_sfAlignToScreen field.
inline
void BillboardBase::setAlignToScreen(const bool &value)
{
    _sfAlignToScreen.setValue(value);
}

//! Get the value of the Billboard::_sfMinAngle field.
inline
Real32 &BillboardBase::getMinAngle(void)
{
    return _sfMinAngle.getValue();
}

//! Get the value of the Billboard::_sfMinAngle field.
inline
const Real32 &BillboardBase::getMinAngle(void) const
{
    return _sfMinAngle.getValue();
}

//! Set the value of the Billboard::_sfMinAngle field.
inline
void BillboardBase::setMinAngle(const Real32 &value)
{
    _sfMinAngle.setValue(value);
}

//! Get the value of the Billboard::_sfMaxAngle field.
inline
Real32 &BillboardBase::getMaxAngle(void)
{
    return _sfMaxAngle.getValue();
}

//! Get the value of the Billboard::_sfMaxAngle field.
inline
const Real32 &BillboardBase::getMaxAngle(void) const
{
    return _sfMaxAngle.getValue();
}

//! Set the value of the Billboard::_sfMaxAngle field.
inline
void BillboardBase::setMaxAngle(const Real32 &value)
{
    _sfMaxAngle.setValue(value);
}


OSG_END_NAMESPACE

#define OSGBILLBOARDBASE_INLINE_CVSID "@(#)$Id: FCBaseTemplate_inl.h,v 1.20 2002/12/04 14:22:22 dirk Exp $"

