/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class BlendChunk
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGBLENDCHUNKBASE_H_
#define _OSGBLENDCHUNKBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGSystemDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGStateChunk.h> // Parent

#include <OSGGLenumFields.h> // SrcFactor type
#include <OSGGLenumFields.h> // DestFactor type
#include <OSGGLenumFields.h> // Equation type
#include <OSGColor4fFields.h> // Color type
#include <OSGGLenumFields.h> // AlphaFunc type
#include <OSGReal32Fields.h> // AlphaValue type
#include <OSGGLenumFields.h> // AlphaSrcFactor type
#include <OSGGLenumFields.h> // AlphaDestFactor type

#include <OSGBlendChunkFields.h>

OSG_BEGIN_NAMESPACE

class BlendChunk;
class BinaryDataHandler;

//! \brief BlendChunk Base Class.

class OSG_SYSTEMLIB_DLLMAPPING BlendChunkBase : public StateChunk
{
  private:

    typedef StateChunk    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef BlendChunkPtr  Ptr;

    enum
    {
        SrcFactorFieldId       = Inherited::NextFieldId,
        DestFactorFieldId      = SrcFactorFieldId       + 1,
        EquationFieldId        = DestFactorFieldId      + 1,
        ColorFieldId           = EquationFieldId        + 1,
        AlphaFuncFieldId       = ColorFieldId           + 1,
        AlphaValueFieldId      = AlphaFuncFieldId       + 1,
        AlphaSrcFactorFieldId  = AlphaValueFieldId      + 1,
        AlphaDestFactorFieldId = AlphaSrcFactorFieldId  + 1,
        NextFieldId            = AlphaDestFactorFieldId + 1
    };

    static const OSG::BitVector SrcFactorFieldMask;
    static const OSG::BitVector DestFactorFieldMask;
    static const OSG::BitVector EquationFieldMask;
    static const OSG::BitVector ColorFieldMask;
    static const OSG::BitVector AlphaFuncFieldMask;
    static const OSG::BitVector AlphaValueFieldMask;
    static const OSG::BitVector AlphaSrcFactorFieldMask;
    static const OSG::BitVector AlphaDestFactorFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFGLenum            *getSFSrcFactor      (void);
           SFGLenum            *getSFDestFactor     (void);
           SFGLenum            *getSFEquation       (void);
           SFColor4f           *getSFColor          (void);
           SFGLenum            *getSFAlphaFunc      (void);
           SFReal32            *getSFAlphaValue     (void);
           SFGLenum            *getSFAlphaSrcFactor (void);
           SFGLenum            *getSFAlphaDestFactor(void);

           GLenum              &getSrcFactor      (void);
     const GLenum              &getSrcFactor      (void) const;
           GLenum              &getDestFactor     (void);
     const GLenum              &getDestFactor     (void) const;
           GLenum              &getEquation       (void);
     const GLenum              &getEquation       (void) const;
           Color4f             &getColor          (void);
     const Color4f             &getColor          (void) const;
           GLenum              &getAlphaFunc      (void);
     const GLenum              &getAlphaFunc      (void) const;
           Real32              &getAlphaValue     (void);
     const Real32              &getAlphaValue     (void) const;
           GLenum              &getAlphaSrcFactor (void);
     const GLenum              &getAlphaSrcFactor (void) const;
           GLenum              &getAlphaDestFactor(void);
     const GLenum              &getAlphaDestFactor(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setSrcFactor      ( const GLenum &value );
     void setDestFactor     ( const GLenum &value );
     void setEquation       ( const GLenum &value );
     void setColor          ( const Color4f &value );
     void setAlphaFunc      ( const GLenum &value );
     void setAlphaValue     ( const Real32 &value );
     void setAlphaSrcFactor ( const GLenum &value );
     void setAlphaDestFactor( const GLenum &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  BlendChunkPtr      create          (void); 
    static  BlendChunkPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFGLenum            _sfSrcFactor;
    SFGLenum            _sfDestFactor;
    SFGLenum            _sfEquation;
    SFColor4f           _sfColor;
    SFGLenum            _sfAlphaFunc;
    SFReal32            _sfAlphaValue;
    SFGLenum            _sfAlphaSrcFactor;
    SFGLenum            _sfAlphaDestFactor;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    BlendChunkBase(void);
    BlendChunkBase(const BlendChunkBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~BlendChunkBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      BlendChunkBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      BlendChunkBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const BlendChunkBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef BlendChunkBase *BlendChunkBaseP;

typedef osgIF<BlendChunkBase::isNodeCore,
              CoredNodePtr<BlendChunk>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet BlendChunkNodePtr;

typedef RefPtr<BlendChunkPtr> BlendChunkRefPtr;

OSG_END_NAMESPACE

#define OSGBLENDCHUNKBASE_HEADER_CVSID "@(#)$Id: FCBaseTemplate_h.h,v 1.40 2005/07/20 00:10:14 vossg Exp $"

#endif /* _OSGBLENDCHUNKBASE_H_ */
