/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class StencilChunk
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGSTENCILCHUNKBASE_H_
#define _OSGSTENCILCHUNKBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGSystemDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGStateChunk.h> // Parent

#include <OSGGLenumFields.h> // StencilFunc type
#include <OSGInt32Fields.h> // StencilValue type
#include <OSGUInt32Fields.h> // StencilMask type
#include <OSGGLenumFields.h> // StencilOpFail type
#include <OSGGLenumFields.h> // StencilOpZFail type
#include <OSGGLenumFields.h> // StencilOpZPass type
#include <OSGInt32Fields.h> // ClearBuffer type
#include <OSGUInt32Fields.h> // BitMask type

#include <OSGStencilChunkFields.h>

OSG_BEGIN_NAMESPACE

class StencilChunk;
class BinaryDataHandler;

//! \brief StencilChunk Base Class.

class OSG_SYSTEMLIB_DLLMAPPING StencilChunkBase : public StateChunk
{
  private:

    typedef StateChunk    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef StencilChunkPtr  Ptr;

    enum
    {
        StencilFuncFieldId    = Inherited::NextFieldId,
        StencilValueFieldId   = StencilFuncFieldId    + 1,
        StencilMaskFieldId    = StencilValueFieldId   + 1,
        StencilOpFailFieldId  = StencilMaskFieldId    + 1,
        StencilOpZFailFieldId = StencilOpFailFieldId  + 1,
        StencilOpZPassFieldId = StencilOpZFailFieldId + 1,
        ClearBufferFieldId    = StencilOpZPassFieldId + 1,
        BitMaskFieldId        = ClearBufferFieldId    + 1,
        NextFieldId           = BitMaskFieldId        + 1
    };

    static const OSG::BitVector StencilFuncFieldMask;
    static const OSG::BitVector StencilValueFieldMask;
    static const OSG::BitVector StencilMaskFieldMask;
    static const OSG::BitVector StencilOpFailFieldMask;
    static const OSG::BitVector StencilOpZFailFieldMask;
    static const OSG::BitVector StencilOpZPassFieldMask;
    static const OSG::BitVector ClearBufferFieldMask;
    static const OSG::BitVector BitMaskFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFGLenum            *getSFStencilFunc    (void);
           SFInt32             *getSFStencilValue   (void);
           SFUInt32            *getSFStencilMask    (void);
           SFGLenum            *getSFStencilOpFail  (void);
           SFGLenum            *getSFStencilOpZFail (void);
           SFGLenum            *getSFStencilOpZPass (void);
           SFInt32             *getSFClearBuffer    (void);
           SFUInt32            *getSFBitMask        (void);

           GLenum              &getStencilFunc    (void);
     const GLenum              &getStencilFunc    (void) const;
           Int32               &getStencilValue   (void);
     const Int32               &getStencilValue   (void) const;
           UInt32              &getStencilMask    (void);
     const UInt32              &getStencilMask    (void) const;
           GLenum              &getStencilOpFail  (void);
     const GLenum              &getStencilOpFail  (void) const;
           GLenum              &getStencilOpZFail (void);
     const GLenum              &getStencilOpZFail (void) const;
           GLenum              &getStencilOpZPass (void);
     const GLenum              &getStencilOpZPass (void) const;
           Int32               &getClearBuffer    (void);
     const Int32               &getClearBuffer    (void) const;
           UInt32              &getBitMask        (void);
     const UInt32              &getBitMask        (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setStencilFunc    ( const GLenum &value );
     void setStencilValue   ( const Int32 &value );
     void setStencilMask    ( const UInt32 &value );
     void setStencilOpFail  ( const GLenum &value );
     void setStencilOpZFail ( const GLenum &value );
     void setStencilOpZPass ( const GLenum &value );
     void setClearBuffer    ( const Int32 &value );
     void setBitMask        ( const UInt32 &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  StencilChunkPtr      create          (void); 
    static  StencilChunkPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFGLenum            _sfStencilFunc;
    SFInt32             _sfStencilValue;
    SFUInt32            _sfStencilMask;
    SFGLenum            _sfStencilOpFail;
    SFGLenum            _sfStencilOpZFail;
    SFGLenum            _sfStencilOpZPass;
    SFInt32             _sfClearBuffer;
    SFUInt32            _sfBitMask;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    StencilChunkBase(void);
    StencilChunkBase(const StencilChunkBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~StencilChunkBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      StencilChunkBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      StencilChunkBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const StencilChunkBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef StencilChunkBase *StencilChunkBaseP;

typedef osgIF<StencilChunkBase::isNodeCore,
              CoredNodePtr<StencilChunk>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet StencilChunkNodePtr;

typedef RefPtr<StencilChunkPtr> StencilChunkRefPtr;

OSG_END_NAMESPACE

#define OSGSTENCILCHUNKBASE_HEADER_CVSID "@(#)$Id: OSGStencilChunkBase.h,v 1.7 2006/09/08 13:45:30 yjung Exp $"

#endif /* _OSGSTENCILCHUNKBASE_H_ */
