/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class TextureChunk!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILETEXTURECHUNKINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGTextureChunkBase.h"
#include "OSGTextureChunk.h"

#include <OSGGL.h>                        // InternalFormat default header
#include <OSGGL.h>                        // ExternalFormat default header
#include <OSGGL.h>                        // MinFilter default header
#include <OSGGL.h>                        // MagFilter default header
#include <OSGGL.h>                        // WrapS default header
#include <OSGGL.h>                        // WrapT default header
#include <OSGGL.h>                        // WrapR default header
#include <OSGGL.h>                        // EnvMode default header
#include <OSGGL.h>                        // EnvCombineRGB default header
#include <OSGGL.h>                        // EnvCombineAlpha default header
#include <OSGGL.h>                        // EnvSource0RGB default header
#include <OSGGLEXT.h>                     // EnvSource1RGB default header
#include <OSGGLEXT.h>                     // EnvSource2RGB default header
#include <OSGGL.h>                        // EnvSource0Alpha default header
#include <OSGGLEXT.h>                     // EnvSource1Alpha default header
#include <OSGGLEXT.h>                     // EnvSource2Alpha default header
#include <OSGGL.h>                        // EnvOperand0RGB default header
#include <OSGGL.h>                        // EnvOperand1RGB default header
#include <OSGGL.h>                        // EnvOperand2RGB default header
#include <OSGGL.h>                        // EnvOperand0Alpha default header
#include <OSGGL.h>                        // EnvOperand1Alpha default header
#include <OSGGL.h>                        // EnvOperand2Alpha default header
#include <OSGGL.h>                        // PointSprite default header
#include <OSGGL.h>                        // ShaderOperation default header
#include <OSGGL.h>                        // ShaderInput default header
#include <OSGGL.h>                        // ShaderRGBADotProduct default header
#include <OSGGL.h>                        // Target default header

OSG_BEGIN_NAMESPACE

const OSG::BitVector  TextureChunkBase::ImageFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::ImageFieldId);

const OSG::BitVector  TextureChunkBase::InternalFormatFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::InternalFormatFieldId);

const OSG::BitVector  TextureChunkBase::ExternalFormatFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::ExternalFormatFieldId);

const OSG::BitVector  TextureChunkBase::ScaleFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::ScaleFieldId);

const OSG::BitVector  TextureChunkBase::FrameFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::FrameFieldId);

const OSG::BitVector  TextureChunkBase::MinFilterFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::MinFilterFieldId);

const OSG::BitVector  TextureChunkBase::MagFilterFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::MagFilterFieldId);

const OSG::BitVector  TextureChunkBase::WrapSFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::WrapSFieldId);

const OSG::BitVector  TextureChunkBase::WrapTFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::WrapTFieldId);

const OSG::BitVector  TextureChunkBase::WrapRFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::WrapRFieldId);

const OSG::BitVector  TextureChunkBase::EnvModeFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvModeFieldId);

const OSG::BitVector  TextureChunkBase::EnvColorFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvColorFieldId);

const OSG::BitVector  TextureChunkBase::EnvCombineRGBFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvCombineRGBFieldId);

const OSG::BitVector  TextureChunkBase::EnvCombineAlphaFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvCombineAlphaFieldId);

const OSG::BitVector  TextureChunkBase::EnvScaleRGBFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvScaleRGBFieldId);

const OSG::BitVector  TextureChunkBase::EnvScaleAlphaFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvScaleAlphaFieldId);

const OSG::BitVector  TextureChunkBase::EnvSource0RGBFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvSource0RGBFieldId);

const OSG::BitVector  TextureChunkBase::EnvSource1RGBFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvSource1RGBFieldId);

const OSG::BitVector  TextureChunkBase::EnvSource2RGBFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvSource2RGBFieldId);

const OSG::BitVector  TextureChunkBase::EnvSource0AlphaFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvSource0AlphaFieldId);

const OSG::BitVector  TextureChunkBase::EnvSource1AlphaFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvSource1AlphaFieldId);

const OSG::BitVector  TextureChunkBase::EnvSource2AlphaFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvSource2AlphaFieldId);

const OSG::BitVector  TextureChunkBase::EnvOperand0RGBFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvOperand0RGBFieldId);

const OSG::BitVector  TextureChunkBase::EnvOperand1RGBFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvOperand1RGBFieldId);

const OSG::BitVector  TextureChunkBase::EnvOperand2RGBFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvOperand2RGBFieldId);

const OSG::BitVector  TextureChunkBase::EnvOperand0AlphaFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvOperand0AlphaFieldId);

const OSG::BitVector  TextureChunkBase::EnvOperand1AlphaFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvOperand1AlphaFieldId);

const OSG::BitVector  TextureChunkBase::EnvOperand2AlphaFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::EnvOperand2AlphaFieldId);

const OSG::BitVector  TextureChunkBase::GLIdFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::GLIdFieldId);

const OSG::BitVector  TextureChunkBase::IgnoreGLForAspectFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::IgnoreGLForAspectFieldId);

const OSG::BitVector  TextureChunkBase::PointSpriteFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::PointSpriteFieldId);

const OSG::BitVector  TextureChunkBase::PriorityFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::PriorityFieldId);

const OSG::BitVector  TextureChunkBase::ShaderOperationFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::ShaderOperationFieldId);

const OSG::BitVector  TextureChunkBase::ShaderInputFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::ShaderInputFieldId);

const OSG::BitVector  TextureChunkBase::ShaderOffsetMatrixFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::ShaderOffsetMatrixFieldId);

const OSG::BitVector  TextureChunkBase::ShaderOffsetScaleFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::ShaderOffsetScaleFieldId);

const OSG::BitVector  TextureChunkBase::ShaderOffsetBiasFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::ShaderOffsetBiasFieldId);

const OSG::BitVector  TextureChunkBase::ShaderRGBADotProductFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::ShaderRGBADotProductFieldId);

const OSG::BitVector  TextureChunkBase::ShaderCullModesFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::ShaderCullModesFieldId);

const OSG::BitVector  TextureChunkBase::ShaderConstEyeFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::ShaderConstEyeFieldId);

const OSG::BitVector  TextureChunkBase::LodBiasFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::LodBiasFieldId);

const OSG::BitVector  TextureChunkBase::TargetFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::TargetFieldId);

const OSG::BitVector  TextureChunkBase::DirtyLeftFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::DirtyLeftFieldId);

const OSG::BitVector  TextureChunkBase::DirtyMinXFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::DirtyMinXFieldId);

const OSG::BitVector  TextureChunkBase::DirtyMaxXFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::DirtyMaxXFieldId);

const OSG::BitVector  TextureChunkBase::DirtyMinYFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::DirtyMinYFieldId);

const OSG::BitVector  TextureChunkBase::DirtyMaxYFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::DirtyMaxYFieldId);

const OSG::BitVector  TextureChunkBase::DirtyMinZFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::DirtyMinZFieldId);

const OSG::BitVector  TextureChunkBase::DirtyMaxZFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::DirtyMaxZFieldId);

const OSG::BitVector  TextureChunkBase::AnisotropyFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::AnisotropyFieldId);

const OSG::BitVector  TextureChunkBase::BorderColorFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::BorderColorFieldId);

const OSG::BitVector  TextureChunkBase::BorderWidthFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::BorderWidthFieldId);

const OSG::BitVector  TextureChunkBase::NPOTMatrixScaleFieldMask = 
    (TypeTraits<BitVector>::One << TextureChunkBase::NPOTMatrixScaleFieldId);

const OSG::BitVector TextureChunkBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var ImagePtr        TextureChunkBase::_sfImage
    The texture.
*/
/*! \var GLenum          TextureChunkBase::_sfInternalFormat
    The internal texture format.
*/
/*! \var GLenum          TextureChunkBase::_sfExternalFormat
    The external texture format - overwrites               external format of image when set to a value not equal to               GL_NONE (which is the default).
*/
/*! \var bool            TextureChunkBase::_sfScale
    Specifies whether the image should be scaled to the next power of two,              thus filling the whole texture coordinate range, or if it should be put              in the lower left corner, leaving the rest of the texture undefined.              This is mainly used for rapidly changing non power of two textures, to              get around the scaling overhead.          If set to false, NPOTMatrixScale can be used to use the texture matrix to correct     the texture coordinates to show the used part of the texture.
*/
/*! \var UInt32          TextureChunkBase::_sfFrame
    Select the frame of the image to be used. See osg::Image about details              concerning multi-frame images.              \hint For fast update use GL_LINEAR or GL_NEAREST filters, as mipmap              creation is slow right now. \endhint
*/
/*! \var GLenum          TextureChunkBase::_sfMinFilter
    The minimisation filter, default GL_LINEAR_MIPMAP_LINEAR.
*/
/*! \var GLenum          TextureChunkBase::_sfMagFilter
    The magnification filter, default GL_LINEAR.
*/
/*! \var GLenum          TextureChunkBase::_sfWrapS
    Texture coordinate S wrapping, default GL_REPEAT.
*/
/*! \var GLenum          TextureChunkBase::_sfWrapT
    Texture coordinate T wrapping, default GL_REPEAT.
*/
/*! \var GLenum          TextureChunkBase::_sfWrapR
    Texture coordinate R wrapping, default GL_REPEAT.
*/
/*! \var GLenum          TextureChunkBase::_sfEnvMode
    Texture environment mode, default GL_REPLACE
*/
/*! \var Color4f         TextureChunkBase::_sfEnvColor
    Texture environment color default transparent black.
*/
/*! \var GLenum          TextureChunkBase::_sfEnvCombineRGB
    Texture environment rgb combine mode, default GL_MODULATE
*/
/*! \var GLenum          TextureChunkBase::_sfEnvCombineAlpha
    Texture environment alpha combine mode, default GL_MODULATE
*/
/*! \var Real32          TextureChunkBase::_sfEnvScaleRGB
    Texture environment combine rgb scale factor, default 1.f
*/
/*! \var Real32          TextureChunkBase::_sfEnvScaleAlpha
    Texture environment combine alpha scale factor, default 1.f
*/
/*! \var GLenum          TextureChunkBase::_sfEnvSource0RGB
    Texture environment combine source 0 rgb, default GL_TEXTURE
*/
/*! \var GLenum          TextureChunkBase::_sfEnvSource1RGB
    Texture environment combine source 1 rgb, default GL_PREVIOUS_EXT
*/
/*! \var GLenum          TextureChunkBase::_sfEnvSource2RGB
    Texture environment combine source 2 rgb, default GL_CONSTANT_EXT
*/
/*! \var GLenum          TextureChunkBase::_sfEnvSource0Alpha
    Texture environment combine source 0 alpha, default GL_TEXTURE
*/
/*! \var GLenum          TextureChunkBase::_sfEnvSource1Alpha
    Texture environment combine source 1 alpha, default GL_PREVIOUS_EXT
*/
/*! \var GLenum          TextureChunkBase::_sfEnvSource2Alpha
    Texture environment combine source 2 alpha, default GL_CONSTANT_EXT
*/
/*! \var GLenum          TextureChunkBase::_sfEnvOperand0RGB
    Texture environment combine operand 0 rgb, default GL_SRC_COLOR
*/
/*! \var GLenum          TextureChunkBase::_sfEnvOperand1RGB
    Texture environment combine operand 1 rgb, default GL_SRC_COLOR
*/
/*! \var GLenum          TextureChunkBase::_sfEnvOperand2RGB
    Texture environment combine operand 2 rgb, default GL_SRC_ALPHA
*/
/*! \var GLenum          TextureChunkBase::_sfEnvOperand0Alpha
    Texture environment combine operand 0 alpha, default GL_SRC_ALPHA
*/
/*! \var GLenum          TextureChunkBase::_sfEnvOperand1Alpha
    Texture environment combine operand 1 alpha, default GL_SRC_ALPHA
*/
/*! \var GLenum          TextureChunkBase::_sfEnvOperand2Alpha
    Texture environment combine operand 2 alpha, default GL_SRC_ALPHA
*/
/*! \var GLenum          TextureChunkBase::_sfGLId
    The OpenGL texture id for this texture.
*/
/*! \var Int32           TextureChunkBase::_sfIgnoreGLForAspect
    The dlist id, if used.
*/
/*! \var bool            TextureChunkBase::_sfPointSprite
    Flag to use this texture for Point Sprites.
*/
/*! \var Real32          TextureChunkBase::_sfPriority
    Priority of this texture, between 0 and 1, the default is 1.
*/
/*! \var GLenum          TextureChunkBase::_sfShaderOperation
    Shader operation of this texture unit, default GL_NONE. If unit 0 uses              GL_NONE, shading is switched off.
*/
/*! \var GLenum          TextureChunkBase::_sfShaderInput
    Input texture unit for this shader's operation.
*/
/*! \var Real32          TextureChunkBase::_mfShaderOffsetMatrix
    The 2x2 transformation matrix for offset textures.
*/
/*! \var Real32          TextureChunkBase::_sfShaderOffsetScale
    The scaling factor for scaled offset textures.
*/
/*! \var Real32          TextureChunkBase::_sfShaderOffsetBias
    The bias factor for scaled offset textures.
*/
/*! \var GLenum          TextureChunkBase::_sfShaderRGBADotProduct
    The RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV value.
*/
/*! \var UInt8           TextureChunkBase::_sfShaderCullModes
    The CULL_MODES_NV value, coded into a single byte. The first 4 bits of              the byte are used to indicate the wnated cull modes, a value of 0               signifies GL_LESS, a value of 1 GL_GEQUAL. Bit 0 (mask 1) is used for the              S coordinate, bit 1 (mask 2) for T, bit 2 (mask 4) for R and bit 4               (mask 8) for Q.
*/
/*! \var Vec3f           TextureChunkBase::_sfShaderConstEye
    The CONST_EYE_NV value, i.e. the constant eye position used by the               DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV shader.
*/
/*! \var Real32          TextureChunkBase::_sfLodBias
    Bias of LOD calculation for texture access.
*/
/*! \var GLenum          TextureChunkBase::_sfTarget
    Texture target. Overwrite automatically determined texture target              based on the parameters of the assigned image if set to anything               else than GL_NONE. Used for nVidia's rectangle textures. Be careful              when using it!
*/
/*! \var Int32           TextureChunkBase::_sfDirtyLeft
    Left coordinate of the dirty rectangle to use for               imageContentChanged(). This doesn't make sense to be stored in files,               it does make sense on a cluster, though, that's why it's external.
*/
/*! \var Int32           TextureChunkBase::_sfDirtyMinX
    Minimum X coordinate of the dirty rectangle to use for               imageContentChanged(). This doesn't make sense to be stored in files,               it does make sense on a cluster, though, that's why it's external.
*/
/*! \var Int32           TextureChunkBase::_sfDirtyMaxX
    Maximum X coordinate of the dirty rectangle to use for               imageContentChanged(). This doesn't make sense to be stored in files,               it does make sense on a cluster, though, that's why it's external.
*/
/*! \var Int32           TextureChunkBase::_sfDirtyMinY
    Minimum Y coordinate of the dirty rectangle to use for               imageContentChanged(). This doesn't make sense to be stored in files,               it does make sense on a cluster, though, that's why it's external.
*/
/*! \var Int32           TextureChunkBase::_sfDirtyMaxY
    Maximum Y coordinate of the dirty rectangle to use for               imageContentChanged(). This doesn't make sense to be stored in files,               it does make sense on a cluster, though, that's why it's external.
*/
/*! \var Int32           TextureChunkBase::_sfDirtyMinZ
    Minimum Z coordinate of the dirty rectangle to use for               imageContentChanged(). This doesn't make sense to be stored in files,               it does make sense on a cluster, though, that's why it's external.
*/
/*! \var Int32           TextureChunkBase::_sfDirtyMaxZ
    Maximum Z coordinate of the dirty rectangle to use for               imageContentChanged(). This doesn't make sense to be stored in files,               it does make sense on a cluster, though, that's why it's external.
*/
/*! \var Real32          TextureChunkBase::_sfAnisotropy
    Texture anisotropy filtering, the default 1.0f means isotropic filtering.
*/
/*! \var Color4f         TextureChunkBase::_sfBorderColor
    Texture border color.
*/
/*! \var UInt32          TextureChunkBase::_sfBorderWidth
    Texture border width in pixels.
*/
/*! \var UInt32          TextureChunkBase::_sfNPOTMatrixScale
    Use the texture matrix to scale the texture coordinates for NPOT images. Only used if neither rectangular nor NPOT textures are supported. If set to false, the image is scaled to the next power of two before being used as a texture. For convenience xFlip/ yFlip can also be set. Note that this will interfere with other TextureTransform and TexGen chunks. Do not use it if you need to use those chunks!
*/

//! TextureChunk description

FieldDescription *TextureChunkBase::_desc[] = 
{
    new FieldDescription(SFImagePtr::getClassType(), 
                     "image", 
                     ImageFieldId, ImageFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFImage),
    new FieldDescription(SFGLenum::getClassType(), 
                     "internalFormat", 
                     InternalFormatFieldId, InternalFormatFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFInternalFormat),
    new FieldDescription(SFGLenum::getClassType(), 
                     "externalFormat", 
                     ExternalFormatFieldId, ExternalFormatFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFExternalFormat),
    new FieldDescription(SFBool::getClassType(), 
                     "scale", 
                     ScaleFieldId, ScaleFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFScale),
    new FieldDescription(SFUInt32::getClassType(), 
                     "frame", 
                     FrameFieldId, FrameFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFFrame),
    new FieldDescription(SFGLenum::getClassType(), 
                     "minFilter", 
                     MinFilterFieldId, MinFilterFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFMinFilter),
    new FieldDescription(SFGLenum::getClassType(), 
                     "magFilter", 
                     MagFilterFieldId, MagFilterFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFMagFilter),
    new FieldDescription(SFGLenum::getClassType(), 
                     "wrapS", 
                     WrapSFieldId, WrapSFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFWrapS),
    new FieldDescription(SFGLenum::getClassType(), 
                     "wrapT", 
                     WrapTFieldId, WrapTFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFWrapT),
    new FieldDescription(SFGLenum::getClassType(), 
                     "wrapR", 
                     WrapRFieldId, WrapRFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFWrapR),
    new FieldDescription(SFGLenum::getClassType(), 
                     "envMode", 
                     EnvModeFieldId, EnvModeFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvMode),
    new FieldDescription(SFColor4f::getClassType(), 
                     "envColor", 
                     EnvColorFieldId, EnvColorFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvColor),
    new FieldDescription(SFGLenum::getClassType(), 
                     "envCombineRGB", 
                     EnvCombineRGBFieldId, EnvCombineRGBFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvCombineRGB),
    new FieldDescription(SFGLenum::getClassType(), 
                     "envCombineAlpha", 
                     EnvCombineAlphaFieldId, EnvCombineAlphaFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvCombineAlpha),
    new FieldDescription(SFReal32::getClassType(), 
                     "envScaleRGB", 
                     EnvScaleRGBFieldId, EnvScaleRGBFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvScaleRGB),
    new FieldDescription(SFReal32::getClassType(), 
                     "envScaleAlpha", 
                     EnvScaleAlphaFieldId, EnvScaleAlphaFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvScaleAlpha),
    new FieldDescription(SFGLenum::getClassType(), 
                     "envSource0RGB", 
                     EnvSource0RGBFieldId, EnvSource0RGBFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvSource0RGB),
    new FieldDescription(SFGLenum::getClassType(), 
                     "envSource1RGB", 
                     EnvSource1RGBFieldId, EnvSource1RGBFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvSource1RGB),
    new FieldDescription(SFGLenum::getClassType(), 
                     "envSource2RGB", 
                     EnvSource2RGBFieldId, EnvSource2RGBFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvSource2RGB),
    new FieldDescription(SFGLenum::getClassType(), 
                     "envSource0Alpha", 
                     EnvSource0AlphaFieldId, EnvSource0AlphaFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvSource0Alpha),
    new FieldDescription(SFGLenum::getClassType(), 
                     "envSource1Alpha", 
                     EnvSource1AlphaFieldId, EnvSource1AlphaFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvSource1Alpha),
    new FieldDescription(SFGLenum::getClassType(), 
                     "envSource2Alpha", 
                     EnvSource2AlphaFieldId, EnvSource2AlphaFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvSource2Alpha),
    new FieldDescription(SFGLenum::getClassType(), 
                     "envOperand0RGB", 
                     EnvOperand0RGBFieldId, EnvOperand0RGBFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvOperand0RGB),
    new FieldDescription(SFGLenum::getClassType(), 
                     "envOperand1RGB", 
                     EnvOperand1RGBFieldId, EnvOperand1RGBFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvOperand1RGB),
    new FieldDescription(SFGLenum::getClassType(), 
                     "envOperand2RGB", 
                     EnvOperand2RGBFieldId, EnvOperand2RGBFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvOperand2RGB),
    new FieldDescription(SFGLenum::getClassType(), 
                     "envOperand0Alpha", 
                     EnvOperand0AlphaFieldId, EnvOperand0AlphaFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvOperand0Alpha),
    new FieldDescription(SFGLenum::getClassType(), 
                     "envOperand1Alpha", 
                     EnvOperand1AlphaFieldId, EnvOperand1AlphaFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvOperand1Alpha),
    new FieldDescription(SFGLenum::getClassType(), 
                     "envOperand2Alpha", 
                     EnvOperand2AlphaFieldId, EnvOperand2AlphaFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFEnvOperand2Alpha),
    new FieldDescription(SFGLenum::getClassType(), 
                     "GLId", 
                     GLIdFieldId, GLIdFieldMask,
                     true,
                     (FieldAccessMethod) &TextureChunkBase::getSFGLId),
    new FieldDescription(SFInt32::getClassType(), 
                     "IgnoreGLForAspect", 
                     IgnoreGLForAspectFieldId, IgnoreGLForAspectFieldMask,
                     true,
                     (FieldAccessMethod) &TextureChunkBase::getSFIgnoreGLForAspect),
    new FieldDescription(SFBool::getClassType(), 
                     "pointSprite", 
                     PointSpriteFieldId, PointSpriteFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFPointSprite),
    new FieldDescription(SFReal32::getClassType(), 
                     "priority", 
                     PriorityFieldId, PriorityFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFPriority),
    new FieldDescription(SFGLenum::getClassType(), 
                     "shaderOperation", 
                     ShaderOperationFieldId, ShaderOperationFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFShaderOperation),
    new FieldDescription(SFGLenum::getClassType(), 
                     "shaderInput", 
                     ShaderInputFieldId, ShaderInputFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFShaderInput),
    new FieldDescription(MFReal32::getClassType(), 
                     "shaderOffsetMatrix", 
                     ShaderOffsetMatrixFieldId, ShaderOffsetMatrixFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getMFShaderOffsetMatrix),
    new FieldDescription(SFReal32::getClassType(), 
                     "shaderOffsetScale", 
                     ShaderOffsetScaleFieldId, ShaderOffsetScaleFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFShaderOffsetScale),
    new FieldDescription(SFReal32::getClassType(), 
                     "shaderOffsetBias", 
                     ShaderOffsetBiasFieldId, ShaderOffsetBiasFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFShaderOffsetBias),
    new FieldDescription(SFGLenum::getClassType(), 
                     "shaderRGBADotProduct", 
                     ShaderRGBADotProductFieldId, ShaderRGBADotProductFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFShaderRGBADotProduct),
    new FieldDescription(SFUInt8::getClassType(), 
                     "shaderCullModes", 
                     ShaderCullModesFieldId, ShaderCullModesFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFShaderCullModes),
    new FieldDescription(SFVec3f::getClassType(), 
                     "shaderConstEye", 
                     ShaderConstEyeFieldId, ShaderConstEyeFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFShaderConstEye),
    new FieldDescription(SFReal32::getClassType(), 
                     "lodBias", 
                     LodBiasFieldId, LodBiasFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFLodBias),
    new FieldDescription(SFGLenum::getClassType(), 
                     "target", 
                     TargetFieldId, TargetFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFTarget),
    new FieldDescription(SFInt32::getClassType(), 
                     "dirtyLeft", 
                     DirtyLeftFieldId, DirtyLeftFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFDirtyLeft),
    new FieldDescription(SFInt32::getClassType(), 
                     "dirtyMinX", 
                     DirtyMinXFieldId, DirtyMinXFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFDirtyMinX),
    new FieldDescription(SFInt32::getClassType(), 
                     "dirtyMaxX", 
                     DirtyMaxXFieldId, DirtyMaxXFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFDirtyMaxX),
    new FieldDescription(SFInt32::getClassType(), 
                     "dirtyMinY", 
                     DirtyMinYFieldId, DirtyMinYFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFDirtyMinY),
    new FieldDescription(SFInt32::getClassType(), 
                     "dirtyMaxY", 
                     DirtyMaxYFieldId, DirtyMaxYFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFDirtyMaxY),
    new FieldDescription(SFInt32::getClassType(), 
                     "dirtyMinZ", 
                     DirtyMinZFieldId, DirtyMinZFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFDirtyMinZ),
    new FieldDescription(SFInt32::getClassType(), 
                     "dirtyMaxZ", 
                     DirtyMaxZFieldId, DirtyMaxZFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFDirtyMaxZ),
    new FieldDescription(SFReal32::getClassType(), 
                     "anisotropy", 
                     AnisotropyFieldId, AnisotropyFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFAnisotropy),
    new FieldDescription(SFColor4f::getClassType(), 
                     "borderColor", 
                     BorderColorFieldId, BorderColorFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFBorderColor),
    new FieldDescription(SFUInt32::getClassType(), 
                     "borderWidth", 
                     BorderWidthFieldId, BorderWidthFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFBorderWidth),
    new FieldDescription(SFUInt32::getClassType(), 
                     "NPOTMatrixScale", 
                     NPOTMatrixScaleFieldId, NPOTMatrixScaleFieldMask,
                     false,
                     (FieldAccessMethod) &TextureChunkBase::getSFNPOTMatrixScale)
};


FieldContainerType TextureChunkBase::_type(
    "TextureChunk",
    "StateChunk",
    NULL,
    (PrototypeCreateF) &TextureChunkBase::createEmpty,
    TextureChunk::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(TextureChunkBase, TextureChunkPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &TextureChunkBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &TextureChunkBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr TextureChunkBase::shallowCopy(void) const 
{ 
    TextureChunkPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const TextureChunk *>(this)); 

    return returnValue; 
}

UInt32 TextureChunkBase::getContainerSize(void) const 
{ 
    return sizeof(TextureChunk); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void TextureChunkBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((TextureChunkBase *) &other, whichField);
}
#else
void TextureChunkBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((TextureChunkBase *) &other, whichField, sInfo);
}
void TextureChunkBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void TextureChunkBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfShaderOffsetMatrix.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

TextureChunkBase::TextureChunkBase(void) :
    _sfImage                  (), 
    _sfInternalFormat         (GLenum(GL_NONE)), 
    _sfExternalFormat         (GLenum(GL_NONE)), 
    _sfScale                  (bool(true)), 
    _sfFrame                  (UInt32(0)), 
    _sfMinFilter              (GLenum(GL_LINEAR_MIPMAP_LINEAR)), 
    _sfMagFilter              (GLenum(GL_LINEAR)), 
    _sfWrapS                  (GLenum(GL_REPEAT)), 
    _sfWrapT                  (GLenum(GL_REPEAT)), 
    _sfWrapR                  (GLenum(GL_REPEAT)), 
    _sfEnvMode                (GLenum(GL_REPLACE)), 
    _sfEnvColor               (Color4f(0,0,0,0)), 
    _sfEnvCombineRGB          (GLenum(GL_MODULATE)), 
    _sfEnvCombineAlpha        (GLenum(GL_MODULATE)), 
    _sfEnvScaleRGB            (Real32(1.0f)), 
    _sfEnvScaleAlpha          (Real32(1.0f)), 
    _sfEnvSource0RGB          (GLenum(GL_TEXTURE)), 
    _sfEnvSource1RGB          (GLenum(GL_PREVIOUS_EXT)), 
    _sfEnvSource2RGB          (GLenum(GL_CONSTANT_EXT)), 
    _sfEnvSource0Alpha        (GLenum(GL_TEXTURE)), 
    _sfEnvSource1Alpha        (GLenum(GL_PREVIOUS_EXT)), 
    _sfEnvSource2Alpha        (GLenum(GL_CONSTANT_EXT)), 
    _sfEnvOperand0RGB         (GLenum(GL_SRC_COLOR)), 
    _sfEnvOperand1RGB         (GLenum(GL_SRC_COLOR)), 
    _sfEnvOperand2RGB         (GLenum(GL_SRC_ALPHA)), 
    _sfEnvOperand0Alpha       (GLenum(GL_SRC_ALPHA)), 
    _sfEnvOperand1Alpha       (GLenum(GL_SRC_ALPHA)), 
    _sfEnvOperand2Alpha       (GLenum(GL_SRC_ALPHA)), 
    _sfGLId                   (GLenum(0)), 
    _sfIgnoreGLForAspect      (Int32(-1)), 
    _sfPointSprite            (bool(GL_FALSE)), 
    _sfPriority               (Real32(1.f)), 
    _sfShaderOperation        (GLenum(GL_NONE)), 
    _sfShaderInput            (GLenum(GL_NONE)), 
    _mfShaderOffsetMatrix     (), 
    _sfShaderOffsetScale      (), 
    _sfShaderOffsetBias       (), 
    _sfShaderRGBADotProduct   (GLenum(GL_NONE)), 
    _sfShaderCullModes        (UInt8(0)), 
    _sfShaderConstEye         (), 
    _sfLodBias                (Real32(0.0)), 
    _sfTarget                 (GLenum(GL_NONE)), 
    _sfDirtyLeft              (Int32(-1)), 
    _sfDirtyMinX              (Int32(-1)), 
    _sfDirtyMaxX              (Int32(-1)), 
    _sfDirtyMinY              (Int32(-1)), 
    _sfDirtyMaxY              (Int32(-1)), 
    _sfDirtyMinZ              (Int32(-1)), 
    _sfDirtyMaxZ              (Int32(-1)), 
    _sfAnisotropy             (Real32(1.0f)), 
    _sfBorderColor            (Color4f(0,0,0,0)), 
    _sfBorderWidth            (UInt32(0)), 
    _sfNPOTMatrixScale        (UInt32(0)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

TextureChunkBase::TextureChunkBase(const TextureChunkBase &source) :
    _sfImage                  (source._sfImage                  ), 
    _sfInternalFormat         (source._sfInternalFormat         ), 
    _sfExternalFormat         (source._sfExternalFormat         ), 
    _sfScale                  (source._sfScale                  ), 
    _sfFrame                  (source._sfFrame                  ), 
    _sfMinFilter              (source._sfMinFilter              ), 
    _sfMagFilter              (source._sfMagFilter              ), 
    _sfWrapS                  (source._sfWrapS                  ), 
    _sfWrapT                  (source._sfWrapT                  ), 
    _sfWrapR                  (source._sfWrapR                  ), 
    _sfEnvMode                (source._sfEnvMode                ), 
    _sfEnvColor               (source._sfEnvColor               ), 
    _sfEnvCombineRGB          (source._sfEnvCombineRGB          ), 
    _sfEnvCombineAlpha        (source._sfEnvCombineAlpha        ), 
    _sfEnvScaleRGB            (source._sfEnvScaleRGB            ), 
    _sfEnvScaleAlpha          (source._sfEnvScaleAlpha          ), 
    _sfEnvSource0RGB          (source._sfEnvSource0RGB          ), 
    _sfEnvSource1RGB          (source._sfEnvSource1RGB          ), 
    _sfEnvSource2RGB          (source._sfEnvSource2RGB          ), 
    _sfEnvSource0Alpha        (source._sfEnvSource0Alpha        ), 
    _sfEnvSource1Alpha        (source._sfEnvSource1Alpha        ), 
    _sfEnvSource2Alpha        (source._sfEnvSource2Alpha        ), 
    _sfEnvOperand0RGB         (source._sfEnvOperand0RGB         ), 
    _sfEnvOperand1RGB         (source._sfEnvOperand1RGB         ), 
    _sfEnvOperand2RGB         (source._sfEnvOperand2RGB         ), 
    _sfEnvOperand0Alpha       (source._sfEnvOperand0Alpha       ), 
    _sfEnvOperand1Alpha       (source._sfEnvOperand1Alpha       ), 
    _sfEnvOperand2Alpha       (source._sfEnvOperand2Alpha       ), 
    _sfGLId                   (source._sfGLId                   ), 
    _sfIgnoreGLForAspect      (source._sfIgnoreGLForAspect      ), 
    _sfPointSprite            (source._sfPointSprite            ), 
    _sfPriority               (source._sfPriority               ), 
    _sfShaderOperation        (source._sfShaderOperation        ), 
    _sfShaderInput            (source._sfShaderInput            ), 
    _mfShaderOffsetMatrix     (source._mfShaderOffsetMatrix     ), 
    _sfShaderOffsetScale      (source._sfShaderOffsetScale      ), 
    _sfShaderOffsetBias       (source._sfShaderOffsetBias       ), 
    _sfShaderRGBADotProduct   (source._sfShaderRGBADotProduct   ), 
    _sfShaderCullModes        (source._sfShaderCullModes        ), 
    _sfShaderConstEye         (source._sfShaderConstEye         ), 
    _sfLodBias                (source._sfLodBias                ), 
    _sfTarget                 (source._sfTarget                 ), 
    _sfDirtyLeft              (source._sfDirtyLeft              ), 
    _sfDirtyMinX              (source._sfDirtyMinX              ), 
    _sfDirtyMaxX              (source._sfDirtyMaxX              ), 
    _sfDirtyMinY              (source._sfDirtyMinY              ), 
    _sfDirtyMaxY              (source._sfDirtyMaxY              ), 
    _sfDirtyMinZ              (source._sfDirtyMinZ              ), 
    _sfDirtyMaxZ              (source._sfDirtyMaxZ              ), 
    _sfAnisotropy             (source._sfAnisotropy             ), 
    _sfBorderColor            (source._sfBorderColor            ), 
    _sfBorderWidth            (source._sfBorderWidth            ), 
    _sfNPOTMatrixScale        (source._sfNPOTMatrixScale        ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

TextureChunkBase::~TextureChunkBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 TextureChunkBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ImageFieldMask & whichField))
    {
        returnValue += _sfImage.getBinSize();
    }

    if(FieldBits::NoField != (InternalFormatFieldMask & whichField))
    {
        returnValue += _sfInternalFormat.getBinSize();
    }

    if(FieldBits::NoField != (ExternalFormatFieldMask & whichField))
    {
        returnValue += _sfExternalFormat.getBinSize();
    }

    if(FieldBits::NoField != (ScaleFieldMask & whichField))
    {
        returnValue += _sfScale.getBinSize();
    }

    if(FieldBits::NoField != (FrameFieldMask & whichField))
    {
        returnValue += _sfFrame.getBinSize();
    }

    if(FieldBits::NoField != (MinFilterFieldMask & whichField))
    {
        returnValue += _sfMinFilter.getBinSize();
    }

    if(FieldBits::NoField != (MagFilterFieldMask & whichField))
    {
        returnValue += _sfMagFilter.getBinSize();
    }

    if(FieldBits::NoField != (WrapSFieldMask & whichField))
    {
        returnValue += _sfWrapS.getBinSize();
    }

    if(FieldBits::NoField != (WrapTFieldMask & whichField))
    {
        returnValue += _sfWrapT.getBinSize();
    }

    if(FieldBits::NoField != (WrapRFieldMask & whichField))
    {
        returnValue += _sfWrapR.getBinSize();
    }

    if(FieldBits::NoField != (EnvModeFieldMask & whichField))
    {
        returnValue += _sfEnvMode.getBinSize();
    }

    if(FieldBits::NoField != (EnvColorFieldMask & whichField))
    {
        returnValue += _sfEnvColor.getBinSize();
    }

    if(FieldBits::NoField != (EnvCombineRGBFieldMask & whichField))
    {
        returnValue += _sfEnvCombineRGB.getBinSize();
    }

    if(FieldBits::NoField != (EnvCombineAlphaFieldMask & whichField))
    {
        returnValue += _sfEnvCombineAlpha.getBinSize();
    }

    if(FieldBits::NoField != (EnvScaleRGBFieldMask & whichField))
    {
        returnValue += _sfEnvScaleRGB.getBinSize();
    }

    if(FieldBits::NoField != (EnvScaleAlphaFieldMask & whichField))
    {
        returnValue += _sfEnvScaleAlpha.getBinSize();
    }

    if(FieldBits::NoField != (EnvSource0RGBFieldMask & whichField))
    {
        returnValue += _sfEnvSource0RGB.getBinSize();
    }

    if(FieldBits::NoField != (EnvSource1RGBFieldMask & whichField))
    {
        returnValue += _sfEnvSource1RGB.getBinSize();
    }

    if(FieldBits::NoField != (EnvSource2RGBFieldMask & whichField))
    {
        returnValue += _sfEnvSource2RGB.getBinSize();
    }

    if(FieldBits::NoField != (EnvSource0AlphaFieldMask & whichField))
    {
        returnValue += _sfEnvSource0Alpha.getBinSize();
    }

    if(FieldBits::NoField != (EnvSource1AlphaFieldMask & whichField))
    {
        returnValue += _sfEnvSource1Alpha.getBinSize();
    }

    if(FieldBits::NoField != (EnvSource2AlphaFieldMask & whichField))
    {
        returnValue += _sfEnvSource2Alpha.getBinSize();
    }

    if(FieldBits::NoField != (EnvOperand0RGBFieldMask & whichField))
    {
        returnValue += _sfEnvOperand0RGB.getBinSize();
    }

    if(FieldBits::NoField != (EnvOperand1RGBFieldMask & whichField))
    {
        returnValue += _sfEnvOperand1RGB.getBinSize();
    }

    if(FieldBits::NoField != (EnvOperand2RGBFieldMask & whichField))
    {
        returnValue += _sfEnvOperand2RGB.getBinSize();
    }

    if(FieldBits::NoField != (EnvOperand0AlphaFieldMask & whichField))
    {
        returnValue += _sfEnvOperand0Alpha.getBinSize();
    }

    if(FieldBits::NoField != (EnvOperand1AlphaFieldMask & whichField))
    {
        returnValue += _sfEnvOperand1Alpha.getBinSize();
    }

    if(FieldBits::NoField != (EnvOperand2AlphaFieldMask & whichField))
    {
        returnValue += _sfEnvOperand2Alpha.getBinSize();
    }

    if(FieldBits::NoField != (GLIdFieldMask & whichField))
    {
        returnValue += _sfGLId.getBinSize();
    }

    if(FieldBits::NoField != (IgnoreGLForAspectFieldMask & whichField))
    {
        returnValue += _sfIgnoreGLForAspect.getBinSize();
    }

    if(FieldBits::NoField != (PointSpriteFieldMask & whichField))
    {
        returnValue += _sfPointSprite.getBinSize();
    }

    if(FieldBits::NoField != (PriorityFieldMask & whichField))
    {
        returnValue += _sfPriority.getBinSize();
    }

    if(FieldBits::NoField != (ShaderOperationFieldMask & whichField))
    {
        returnValue += _sfShaderOperation.getBinSize();
    }

    if(FieldBits::NoField != (ShaderInputFieldMask & whichField))
    {
        returnValue += _sfShaderInput.getBinSize();
    }

    if(FieldBits::NoField != (ShaderOffsetMatrixFieldMask & whichField))
    {
        returnValue += _mfShaderOffsetMatrix.getBinSize();
    }

    if(FieldBits::NoField != (ShaderOffsetScaleFieldMask & whichField))
    {
        returnValue += _sfShaderOffsetScale.getBinSize();
    }

    if(FieldBits::NoField != (ShaderOffsetBiasFieldMask & whichField))
    {
        returnValue += _sfShaderOffsetBias.getBinSize();
    }

    if(FieldBits::NoField != (ShaderRGBADotProductFieldMask & whichField))
    {
        returnValue += _sfShaderRGBADotProduct.getBinSize();
    }

    if(FieldBits::NoField != (ShaderCullModesFieldMask & whichField))
    {
        returnValue += _sfShaderCullModes.getBinSize();
    }

    if(FieldBits::NoField != (ShaderConstEyeFieldMask & whichField))
    {
        returnValue += _sfShaderConstEye.getBinSize();
    }

    if(FieldBits::NoField != (LodBiasFieldMask & whichField))
    {
        returnValue += _sfLodBias.getBinSize();
    }

    if(FieldBits::NoField != (TargetFieldMask & whichField))
    {
        returnValue += _sfTarget.getBinSize();
    }

    if(FieldBits::NoField != (DirtyLeftFieldMask & whichField))
    {
        returnValue += _sfDirtyLeft.getBinSize();
    }

    if(FieldBits::NoField != (DirtyMinXFieldMask & whichField))
    {
        returnValue += _sfDirtyMinX.getBinSize();
    }

    if(FieldBits::NoField != (DirtyMaxXFieldMask & whichField))
    {
        returnValue += _sfDirtyMaxX.getBinSize();
    }

    if(FieldBits::NoField != (DirtyMinYFieldMask & whichField))
    {
        returnValue += _sfDirtyMinY.getBinSize();
    }

    if(FieldBits::NoField != (DirtyMaxYFieldMask & whichField))
    {
        returnValue += _sfDirtyMaxY.getBinSize();
    }

    if(FieldBits::NoField != (DirtyMinZFieldMask & whichField))
    {
        returnValue += _sfDirtyMinZ.getBinSize();
    }

    if(FieldBits::NoField != (DirtyMaxZFieldMask & whichField))
    {
        returnValue += _sfDirtyMaxZ.getBinSize();
    }

    if(FieldBits::NoField != (AnisotropyFieldMask & whichField))
    {
        returnValue += _sfAnisotropy.getBinSize();
    }

    if(FieldBits::NoField != (BorderColorFieldMask & whichField))
    {
        returnValue += _sfBorderColor.getBinSize();
    }

    if(FieldBits::NoField != (BorderWidthFieldMask & whichField))
    {
        returnValue += _sfBorderWidth.getBinSize();
    }

    if(FieldBits::NoField != (NPOTMatrixScaleFieldMask & whichField))
    {
        returnValue += _sfNPOTMatrixScale.getBinSize();
    }


    return returnValue;
}

void TextureChunkBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ImageFieldMask & whichField))
    {
        _sfImage.copyToBin(pMem);
    }

    if(FieldBits::NoField != (InternalFormatFieldMask & whichField))
    {
        _sfInternalFormat.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ExternalFormatFieldMask & whichField))
    {
        _sfExternalFormat.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ScaleFieldMask & whichField))
    {
        _sfScale.copyToBin(pMem);
    }

    if(FieldBits::NoField != (FrameFieldMask & whichField))
    {
        _sfFrame.copyToBin(pMem);
    }

    if(FieldBits::NoField != (MinFilterFieldMask & whichField))
    {
        _sfMinFilter.copyToBin(pMem);
    }

    if(FieldBits::NoField != (MagFilterFieldMask & whichField))
    {
        _sfMagFilter.copyToBin(pMem);
    }

    if(FieldBits::NoField != (WrapSFieldMask & whichField))
    {
        _sfWrapS.copyToBin(pMem);
    }

    if(FieldBits::NoField != (WrapTFieldMask & whichField))
    {
        _sfWrapT.copyToBin(pMem);
    }

    if(FieldBits::NoField != (WrapRFieldMask & whichField))
    {
        _sfWrapR.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvModeFieldMask & whichField))
    {
        _sfEnvMode.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvColorFieldMask & whichField))
    {
        _sfEnvColor.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvCombineRGBFieldMask & whichField))
    {
        _sfEnvCombineRGB.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvCombineAlphaFieldMask & whichField))
    {
        _sfEnvCombineAlpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvScaleRGBFieldMask & whichField))
    {
        _sfEnvScaleRGB.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvScaleAlphaFieldMask & whichField))
    {
        _sfEnvScaleAlpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvSource0RGBFieldMask & whichField))
    {
        _sfEnvSource0RGB.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvSource1RGBFieldMask & whichField))
    {
        _sfEnvSource1RGB.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvSource2RGBFieldMask & whichField))
    {
        _sfEnvSource2RGB.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvSource0AlphaFieldMask & whichField))
    {
        _sfEnvSource0Alpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvSource1AlphaFieldMask & whichField))
    {
        _sfEnvSource1Alpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvSource2AlphaFieldMask & whichField))
    {
        _sfEnvSource2Alpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvOperand0RGBFieldMask & whichField))
    {
        _sfEnvOperand0RGB.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvOperand1RGBFieldMask & whichField))
    {
        _sfEnvOperand1RGB.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvOperand2RGBFieldMask & whichField))
    {
        _sfEnvOperand2RGB.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvOperand0AlphaFieldMask & whichField))
    {
        _sfEnvOperand0Alpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvOperand1AlphaFieldMask & whichField))
    {
        _sfEnvOperand1Alpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnvOperand2AlphaFieldMask & whichField))
    {
        _sfEnvOperand2Alpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (GLIdFieldMask & whichField))
    {
        _sfGLId.copyToBin(pMem);
    }

    if(FieldBits::NoField != (IgnoreGLForAspectFieldMask & whichField))
    {
        _sfIgnoreGLForAspect.copyToBin(pMem);
    }

    if(FieldBits::NoField != (PointSpriteFieldMask & whichField))
    {
        _sfPointSprite.copyToBin(pMem);
    }

    if(FieldBits::NoField != (PriorityFieldMask & whichField))
    {
        _sfPriority.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ShaderOperationFieldMask & whichField))
    {
        _sfShaderOperation.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ShaderInputFieldMask & whichField))
    {
        _sfShaderInput.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ShaderOffsetMatrixFieldMask & whichField))
    {
        _mfShaderOffsetMatrix.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ShaderOffsetScaleFieldMask & whichField))
    {
        _sfShaderOffsetScale.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ShaderOffsetBiasFieldMask & whichField))
    {
        _sfShaderOffsetBias.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ShaderRGBADotProductFieldMask & whichField))
    {
        _sfShaderRGBADotProduct.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ShaderCullModesFieldMask & whichField))
    {
        _sfShaderCullModes.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ShaderConstEyeFieldMask & whichField))
    {
        _sfShaderConstEye.copyToBin(pMem);
    }

    if(FieldBits::NoField != (LodBiasFieldMask & whichField))
    {
        _sfLodBias.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TargetFieldMask & whichField))
    {
        _sfTarget.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DirtyLeftFieldMask & whichField))
    {
        _sfDirtyLeft.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DirtyMinXFieldMask & whichField))
    {
        _sfDirtyMinX.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DirtyMaxXFieldMask & whichField))
    {
        _sfDirtyMaxX.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DirtyMinYFieldMask & whichField))
    {
        _sfDirtyMinY.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DirtyMaxYFieldMask & whichField))
    {
        _sfDirtyMaxY.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DirtyMinZFieldMask & whichField))
    {
        _sfDirtyMinZ.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DirtyMaxZFieldMask & whichField))
    {
        _sfDirtyMaxZ.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AnisotropyFieldMask & whichField))
    {
        _sfAnisotropy.copyToBin(pMem);
    }

    if(FieldBits::NoField != (BorderColorFieldMask & whichField))
    {
        _sfBorderColor.copyToBin(pMem);
    }

    if(FieldBits::NoField != (BorderWidthFieldMask & whichField))
    {
        _sfBorderWidth.copyToBin(pMem);
    }

    if(FieldBits::NoField != (NPOTMatrixScaleFieldMask & whichField))
    {
        _sfNPOTMatrixScale.copyToBin(pMem);
    }


}

void TextureChunkBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ImageFieldMask & whichField))
    {
        _sfImage.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (InternalFormatFieldMask & whichField))
    {
        _sfInternalFormat.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ExternalFormatFieldMask & whichField))
    {
        _sfExternalFormat.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ScaleFieldMask & whichField))
    {
        _sfScale.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (FrameFieldMask & whichField))
    {
        _sfFrame.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (MinFilterFieldMask & whichField))
    {
        _sfMinFilter.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (MagFilterFieldMask & whichField))
    {
        _sfMagFilter.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (WrapSFieldMask & whichField))
    {
        _sfWrapS.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (WrapTFieldMask & whichField))
    {
        _sfWrapT.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (WrapRFieldMask & whichField))
    {
        _sfWrapR.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvModeFieldMask & whichField))
    {
        _sfEnvMode.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvColorFieldMask & whichField))
    {
        _sfEnvColor.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvCombineRGBFieldMask & whichField))
    {
        _sfEnvCombineRGB.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvCombineAlphaFieldMask & whichField))
    {
        _sfEnvCombineAlpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvScaleRGBFieldMask & whichField))
    {
        _sfEnvScaleRGB.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvScaleAlphaFieldMask & whichField))
    {
        _sfEnvScaleAlpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvSource0RGBFieldMask & whichField))
    {
        _sfEnvSource0RGB.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvSource1RGBFieldMask & whichField))
    {
        _sfEnvSource1RGB.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvSource2RGBFieldMask & whichField))
    {
        _sfEnvSource2RGB.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvSource0AlphaFieldMask & whichField))
    {
        _sfEnvSource0Alpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvSource1AlphaFieldMask & whichField))
    {
        _sfEnvSource1Alpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvSource2AlphaFieldMask & whichField))
    {
        _sfEnvSource2Alpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvOperand0RGBFieldMask & whichField))
    {
        _sfEnvOperand0RGB.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvOperand1RGBFieldMask & whichField))
    {
        _sfEnvOperand1RGB.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvOperand2RGBFieldMask & whichField))
    {
        _sfEnvOperand2RGB.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvOperand0AlphaFieldMask & whichField))
    {
        _sfEnvOperand0Alpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvOperand1AlphaFieldMask & whichField))
    {
        _sfEnvOperand1Alpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnvOperand2AlphaFieldMask & whichField))
    {
        _sfEnvOperand2Alpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (GLIdFieldMask & whichField))
    {
        _sfGLId.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (IgnoreGLForAspectFieldMask & whichField))
    {
        _sfIgnoreGLForAspect.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (PointSpriteFieldMask & whichField))
    {
        _sfPointSprite.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (PriorityFieldMask & whichField))
    {
        _sfPriority.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ShaderOperationFieldMask & whichField))
    {
        _sfShaderOperation.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ShaderInputFieldMask & whichField))
    {
        _sfShaderInput.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ShaderOffsetMatrixFieldMask & whichField))
    {
        _mfShaderOffsetMatrix.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ShaderOffsetScaleFieldMask & whichField))
    {
        _sfShaderOffsetScale.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ShaderOffsetBiasFieldMask & whichField))
    {
        _sfShaderOffsetBias.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ShaderRGBADotProductFieldMask & whichField))
    {
        _sfShaderRGBADotProduct.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ShaderCullModesFieldMask & whichField))
    {
        _sfShaderCullModes.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ShaderConstEyeFieldMask & whichField))
    {
        _sfShaderConstEye.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (LodBiasFieldMask & whichField))
    {
        _sfLodBias.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TargetFieldMask & whichField))
    {
        _sfTarget.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DirtyLeftFieldMask & whichField))
    {
        _sfDirtyLeft.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DirtyMinXFieldMask & whichField))
    {
        _sfDirtyMinX.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DirtyMaxXFieldMask & whichField))
    {
        _sfDirtyMaxX.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DirtyMinYFieldMask & whichField))
    {
        _sfDirtyMinY.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DirtyMaxYFieldMask & whichField))
    {
        _sfDirtyMaxY.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DirtyMinZFieldMask & whichField))
    {
        _sfDirtyMinZ.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DirtyMaxZFieldMask & whichField))
    {
        _sfDirtyMaxZ.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AnisotropyFieldMask & whichField))
    {
        _sfAnisotropy.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (BorderColorFieldMask & whichField))
    {
        _sfBorderColor.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (BorderWidthFieldMask & whichField))
    {
        _sfBorderWidth.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (NPOTMatrixScaleFieldMask & whichField))
    {
        _sfNPOTMatrixScale.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void TextureChunkBase::executeSyncImpl(      TextureChunkBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ImageFieldMask & whichField))
        _sfImage.syncWith(pOther->_sfImage);

    if(FieldBits::NoField != (InternalFormatFieldMask & whichField))
        _sfInternalFormat.syncWith(pOther->_sfInternalFormat);

    if(FieldBits::NoField != (ExternalFormatFieldMask & whichField))
        _sfExternalFormat.syncWith(pOther->_sfExternalFormat);

    if(FieldBits::NoField != (ScaleFieldMask & whichField))
        _sfScale.syncWith(pOther->_sfScale);

    if(FieldBits::NoField != (FrameFieldMask & whichField))
        _sfFrame.syncWith(pOther->_sfFrame);

    if(FieldBits::NoField != (MinFilterFieldMask & whichField))
        _sfMinFilter.syncWith(pOther->_sfMinFilter);

    if(FieldBits::NoField != (MagFilterFieldMask & whichField))
        _sfMagFilter.syncWith(pOther->_sfMagFilter);

    if(FieldBits::NoField != (WrapSFieldMask & whichField))
        _sfWrapS.syncWith(pOther->_sfWrapS);

    if(FieldBits::NoField != (WrapTFieldMask & whichField))
        _sfWrapT.syncWith(pOther->_sfWrapT);

    if(FieldBits::NoField != (WrapRFieldMask & whichField))
        _sfWrapR.syncWith(pOther->_sfWrapR);

    if(FieldBits::NoField != (EnvModeFieldMask & whichField))
        _sfEnvMode.syncWith(pOther->_sfEnvMode);

    if(FieldBits::NoField != (EnvColorFieldMask & whichField))
        _sfEnvColor.syncWith(pOther->_sfEnvColor);

    if(FieldBits::NoField != (EnvCombineRGBFieldMask & whichField))
        _sfEnvCombineRGB.syncWith(pOther->_sfEnvCombineRGB);

    if(FieldBits::NoField != (EnvCombineAlphaFieldMask & whichField))
        _sfEnvCombineAlpha.syncWith(pOther->_sfEnvCombineAlpha);

    if(FieldBits::NoField != (EnvScaleRGBFieldMask & whichField))
        _sfEnvScaleRGB.syncWith(pOther->_sfEnvScaleRGB);

    if(FieldBits::NoField != (EnvScaleAlphaFieldMask & whichField))
        _sfEnvScaleAlpha.syncWith(pOther->_sfEnvScaleAlpha);

    if(FieldBits::NoField != (EnvSource0RGBFieldMask & whichField))
        _sfEnvSource0RGB.syncWith(pOther->_sfEnvSource0RGB);

    if(FieldBits::NoField != (EnvSource1RGBFieldMask & whichField))
        _sfEnvSource1RGB.syncWith(pOther->_sfEnvSource1RGB);

    if(FieldBits::NoField != (EnvSource2RGBFieldMask & whichField))
        _sfEnvSource2RGB.syncWith(pOther->_sfEnvSource2RGB);

    if(FieldBits::NoField != (EnvSource0AlphaFieldMask & whichField))
        _sfEnvSource0Alpha.syncWith(pOther->_sfEnvSource0Alpha);

    if(FieldBits::NoField != (EnvSource1AlphaFieldMask & whichField))
        _sfEnvSource1Alpha.syncWith(pOther->_sfEnvSource1Alpha);

    if(FieldBits::NoField != (EnvSource2AlphaFieldMask & whichField))
        _sfEnvSource2Alpha.syncWith(pOther->_sfEnvSource2Alpha);

    if(FieldBits::NoField != (EnvOperand0RGBFieldMask & whichField))
        _sfEnvOperand0RGB.syncWith(pOther->_sfEnvOperand0RGB);

    if(FieldBits::NoField != (EnvOperand1RGBFieldMask & whichField))
        _sfEnvOperand1RGB.syncWith(pOther->_sfEnvOperand1RGB);

    if(FieldBits::NoField != (EnvOperand2RGBFieldMask & whichField))
        _sfEnvOperand2RGB.syncWith(pOther->_sfEnvOperand2RGB);

    if(FieldBits::NoField != (EnvOperand0AlphaFieldMask & whichField))
        _sfEnvOperand0Alpha.syncWith(pOther->_sfEnvOperand0Alpha);

    if(FieldBits::NoField != (EnvOperand1AlphaFieldMask & whichField))
        _sfEnvOperand1Alpha.syncWith(pOther->_sfEnvOperand1Alpha);

    if(FieldBits::NoField != (EnvOperand2AlphaFieldMask & whichField))
        _sfEnvOperand2Alpha.syncWith(pOther->_sfEnvOperand2Alpha);

    if(FieldBits::NoField != (GLIdFieldMask & whichField))
        _sfGLId.syncWith(pOther->_sfGLId);

    if(FieldBits::NoField != (IgnoreGLForAspectFieldMask & whichField))
        _sfIgnoreGLForAspect.syncWith(pOther->_sfIgnoreGLForAspect);

    if(FieldBits::NoField != (PointSpriteFieldMask & whichField))
        _sfPointSprite.syncWith(pOther->_sfPointSprite);

    if(FieldBits::NoField != (PriorityFieldMask & whichField))
        _sfPriority.syncWith(pOther->_sfPriority);

    if(FieldBits::NoField != (ShaderOperationFieldMask & whichField))
        _sfShaderOperation.syncWith(pOther->_sfShaderOperation);

    if(FieldBits::NoField != (ShaderInputFieldMask & whichField))
        _sfShaderInput.syncWith(pOther->_sfShaderInput);

    if(FieldBits::NoField != (ShaderOffsetMatrixFieldMask & whichField))
        _mfShaderOffsetMatrix.syncWith(pOther->_mfShaderOffsetMatrix);

    if(FieldBits::NoField != (ShaderOffsetScaleFieldMask & whichField))
        _sfShaderOffsetScale.syncWith(pOther->_sfShaderOffsetScale);

    if(FieldBits::NoField != (ShaderOffsetBiasFieldMask & whichField))
        _sfShaderOffsetBias.syncWith(pOther->_sfShaderOffsetBias);

    if(FieldBits::NoField != (ShaderRGBADotProductFieldMask & whichField))
        _sfShaderRGBADotProduct.syncWith(pOther->_sfShaderRGBADotProduct);

    if(FieldBits::NoField != (ShaderCullModesFieldMask & whichField))
        _sfShaderCullModes.syncWith(pOther->_sfShaderCullModes);

    if(FieldBits::NoField != (ShaderConstEyeFieldMask & whichField))
        _sfShaderConstEye.syncWith(pOther->_sfShaderConstEye);

    if(FieldBits::NoField != (LodBiasFieldMask & whichField))
        _sfLodBias.syncWith(pOther->_sfLodBias);

    if(FieldBits::NoField != (TargetFieldMask & whichField))
        _sfTarget.syncWith(pOther->_sfTarget);

    if(FieldBits::NoField != (DirtyLeftFieldMask & whichField))
        _sfDirtyLeft.syncWith(pOther->_sfDirtyLeft);

    if(FieldBits::NoField != (DirtyMinXFieldMask & whichField))
        _sfDirtyMinX.syncWith(pOther->_sfDirtyMinX);

    if(FieldBits::NoField != (DirtyMaxXFieldMask & whichField))
        _sfDirtyMaxX.syncWith(pOther->_sfDirtyMaxX);

    if(FieldBits::NoField != (DirtyMinYFieldMask & whichField))
        _sfDirtyMinY.syncWith(pOther->_sfDirtyMinY);

    if(FieldBits::NoField != (DirtyMaxYFieldMask & whichField))
        _sfDirtyMaxY.syncWith(pOther->_sfDirtyMaxY);

    if(FieldBits::NoField != (DirtyMinZFieldMask & whichField))
        _sfDirtyMinZ.syncWith(pOther->_sfDirtyMinZ);

    if(FieldBits::NoField != (DirtyMaxZFieldMask & whichField))
        _sfDirtyMaxZ.syncWith(pOther->_sfDirtyMaxZ);

    if(FieldBits::NoField != (AnisotropyFieldMask & whichField))
        _sfAnisotropy.syncWith(pOther->_sfAnisotropy);

    if(FieldBits::NoField != (BorderColorFieldMask & whichField))
        _sfBorderColor.syncWith(pOther->_sfBorderColor);

    if(FieldBits::NoField != (BorderWidthFieldMask & whichField))
        _sfBorderWidth.syncWith(pOther->_sfBorderWidth);

    if(FieldBits::NoField != (NPOTMatrixScaleFieldMask & whichField))
        _sfNPOTMatrixScale.syncWith(pOther->_sfNPOTMatrixScale);


}
#else
void TextureChunkBase::executeSyncImpl(      TextureChunkBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (ImageFieldMask & whichField))
        _sfImage.syncWith(pOther->_sfImage);

    if(FieldBits::NoField != (InternalFormatFieldMask & whichField))
        _sfInternalFormat.syncWith(pOther->_sfInternalFormat);

    if(FieldBits::NoField != (ExternalFormatFieldMask & whichField))
        _sfExternalFormat.syncWith(pOther->_sfExternalFormat);

    if(FieldBits::NoField != (ScaleFieldMask & whichField))
        _sfScale.syncWith(pOther->_sfScale);

    if(FieldBits::NoField != (FrameFieldMask & whichField))
        _sfFrame.syncWith(pOther->_sfFrame);

    if(FieldBits::NoField != (MinFilterFieldMask & whichField))
        _sfMinFilter.syncWith(pOther->_sfMinFilter);

    if(FieldBits::NoField != (MagFilterFieldMask & whichField))
        _sfMagFilter.syncWith(pOther->_sfMagFilter);

    if(FieldBits::NoField != (WrapSFieldMask & whichField))
        _sfWrapS.syncWith(pOther->_sfWrapS);

    if(FieldBits::NoField != (WrapTFieldMask & whichField))
        _sfWrapT.syncWith(pOther->_sfWrapT);

    if(FieldBits::NoField != (WrapRFieldMask & whichField))
        _sfWrapR.syncWith(pOther->_sfWrapR);

    if(FieldBits::NoField != (EnvModeFieldMask & whichField))
        _sfEnvMode.syncWith(pOther->_sfEnvMode);

    if(FieldBits::NoField != (EnvColorFieldMask & whichField))
        _sfEnvColor.syncWith(pOther->_sfEnvColor);

    if(FieldBits::NoField != (EnvCombineRGBFieldMask & whichField))
        _sfEnvCombineRGB.syncWith(pOther->_sfEnvCombineRGB);

    if(FieldBits::NoField != (EnvCombineAlphaFieldMask & whichField))
        _sfEnvCombineAlpha.syncWith(pOther->_sfEnvCombineAlpha);

    if(FieldBits::NoField != (EnvScaleRGBFieldMask & whichField))
        _sfEnvScaleRGB.syncWith(pOther->_sfEnvScaleRGB);

    if(FieldBits::NoField != (EnvScaleAlphaFieldMask & whichField))
        _sfEnvScaleAlpha.syncWith(pOther->_sfEnvScaleAlpha);

    if(FieldBits::NoField != (EnvSource0RGBFieldMask & whichField))
        _sfEnvSource0RGB.syncWith(pOther->_sfEnvSource0RGB);

    if(FieldBits::NoField != (EnvSource1RGBFieldMask & whichField))
        _sfEnvSource1RGB.syncWith(pOther->_sfEnvSource1RGB);

    if(FieldBits::NoField != (EnvSource2RGBFieldMask & whichField))
        _sfEnvSource2RGB.syncWith(pOther->_sfEnvSource2RGB);

    if(FieldBits::NoField != (EnvSource0AlphaFieldMask & whichField))
        _sfEnvSource0Alpha.syncWith(pOther->_sfEnvSource0Alpha);

    if(FieldBits::NoField != (EnvSource1AlphaFieldMask & whichField))
        _sfEnvSource1Alpha.syncWith(pOther->_sfEnvSource1Alpha);

    if(FieldBits::NoField != (EnvSource2AlphaFieldMask & whichField))
        _sfEnvSource2Alpha.syncWith(pOther->_sfEnvSource2Alpha);

    if(FieldBits::NoField != (EnvOperand0RGBFieldMask & whichField))
        _sfEnvOperand0RGB.syncWith(pOther->_sfEnvOperand0RGB);

    if(FieldBits::NoField != (EnvOperand1RGBFieldMask & whichField))
        _sfEnvOperand1RGB.syncWith(pOther->_sfEnvOperand1RGB);

    if(FieldBits::NoField != (EnvOperand2RGBFieldMask & whichField))
        _sfEnvOperand2RGB.syncWith(pOther->_sfEnvOperand2RGB);

    if(FieldBits::NoField != (EnvOperand0AlphaFieldMask & whichField))
        _sfEnvOperand0Alpha.syncWith(pOther->_sfEnvOperand0Alpha);

    if(FieldBits::NoField != (EnvOperand1AlphaFieldMask & whichField))
        _sfEnvOperand1Alpha.syncWith(pOther->_sfEnvOperand1Alpha);

    if(FieldBits::NoField != (EnvOperand2AlphaFieldMask & whichField))
        _sfEnvOperand2Alpha.syncWith(pOther->_sfEnvOperand2Alpha);

    if(FieldBits::NoField != (GLIdFieldMask & whichField))
        _sfGLId.syncWith(pOther->_sfGLId);

    if(FieldBits::NoField != (IgnoreGLForAspectFieldMask & whichField))
        _sfIgnoreGLForAspect.syncWith(pOther->_sfIgnoreGLForAspect);

    if(FieldBits::NoField != (PointSpriteFieldMask & whichField))
        _sfPointSprite.syncWith(pOther->_sfPointSprite);

    if(FieldBits::NoField != (PriorityFieldMask & whichField))
        _sfPriority.syncWith(pOther->_sfPriority);

    if(FieldBits::NoField != (ShaderOperationFieldMask & whichField))
        _sfShaderOperation.syncWith(pOther->_sfShaderOperation);

    if(FieldBits::NoField != (ShaderInputFieldMask & whichField))
        _sfShaderInput.syncWith(pOther->_sfShaderInput);

    if(FieldBits::NoField != (ShaderOffsetScaleFieldMask & whichField))
        _sfShaderOffsetScale.syncWith(pOther->_sfShaderOffsetScale);

    if(FieldBits::NoField != (ShaderOffsetBiasFieldMask & whichField))
        _sfShaderOffsetBias.syncWith(pOther->_sfShaderOffsetBias);

    if(FieldBits::NoField != (ShaderRGBADotProductFieldMask & whichField))
        _sfShaderRGBADotProduct.syncWith(pOther->_sfShaderRGBADotProduct);

    if(FieldBits::NoField != (ShaderCullModesFieldMask & whichField))
        _sfShaderCullModes.syncWith(pOther->_sfShaderCullModes);

    if(FieldBits::NoField != (ShaderConstEyeFieldMask & whichField))
        _sfShaderConstEye.syncWith(pOther->_sfShaderConstEye);

    if(FieldBits::NoField != (LodBiasFieldMask & whichField))
        _sfLodBias.syncWith(pOther->_sfLodBias);

    if(FieldBits::NoField != (TargetFieldMask & whichField))
        _sfTarget.syncWith(pOther->_sfTarget);

    if(FieldBits::NoField != (DirtyLeftFieldMask & whichField))
        _sfDirtyLeft.syncWith(pOther->_sfDirtyLeft);

    if(FieldBits::NoField != (DirtyMinXFieldMask & whichField))
        _sfDirtyMinX.syncWith(pOther->_sfDirtyMinX);

    if(FieldBits::NoField != (DirtyMaxXFieldMask & whichField))
        _sfDirtyMaxX.syncWith(pOther->_sfDirtyMaxX);

    if(FieldBits::NoField != (DirtyMinYFieldMask & whichField))
        _sfDirtyMinY.syncWith(pOther->_sfDirtyMinY);

    if(FieldBits::NoField != (DirtyMaxYFieldMask & whichField))
        _sfDirtyMaxY.syncWith(pOther->_sfDirtyMaxY);

    if(FieldBits::NoField != (DirtyMinZFieldMask & whichField))
        _sfDirtyMinZ.syncWith(pOther->_sfDirtyMinZ);

    if(FieldBits::NoField != (DirtyMaxZFieldMask & whichField))
        _sfDirtyMaxZ.syncWith(pOther->_sfDirtyMaxZ);

    if(FieldBits::NoField != (AnisotropyFieldMask & whichField))
        _sfAnisotropy.syncWith(pOther->_sfAnisotropy);

    if(FieldBits::NoField != (BorderColorFieldMask & whichField))
        _sfBorderColor.syncWith(pOther->_sfBorderColor);

    if(FieldBits::NoField != (BorderWidthFieldMask & whichField))
        _sfBorderWidth.syncWith(pOther->_sfBorderWidth);

    if(FieldBits::NoField != (NPOTMatrixScaleFieldMask & whichField))
        _sfNPOTMatrixScale.syncWith(pOther->_sfNPOTMatrixScale);


    if(FieldBits::NoField != (ShaderOffsetMatrixFieldMask & whichField))
        _mfShaderOffsetMatrix.syncWith(pOther->_mfShaderOffsetMatrix, sInfo);


}

void TextureChunkBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (ShaderOffsetMatrixFieldMask & whichField))
        _mfShaderOffsetMatrix.beginEdit(uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<TextureChunkPtr>::_type("TextureChunkPtr", "StateChunkPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(TextureChunkPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(TextureChunkPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.47 2006/03/17 17:03:19 pdaehne Exp $";
    static Char8 cvsid_hpp       [] = OSGTEXTURECHUNKBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGTEXTURECHUNKBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGTEXTURECHUNKFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

