/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class ColorDisplayFilter
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGCOLORDISPLAYFILTERBASE_H_
#define _OSGCOLORDISPLAYFILTERBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGSystemDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGDisplayFilter.h> // Parent

#include <OSGReal32Fields.h> // Gamma type
#include <OSGMatrixFields.h> // Matrix type
#include <OSGUInt32Fields.h> // Width type
#include <OSGUInt32Fields.h> // Height type
#include <OSGUInt32Fields.h> // Depth type
#include <OSGColor3fFields.h> // Table type

#include <OSGColorDisplayFilterFields.h>

OSG_BEGIN_NAMESPACE

class ColorDisplayFilter;
class BinaryDataHandler;

//! \brief ColorDisplayFilter Base Class.

class OSG_SYSTEMLIB_DLLMAPPING ColorDisplayFilterBase : public DisplayFilter
{
  private:

    typedef DisplayFilter    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef ColorDisplayFilterPtr  Ptr;

    enum
    {
        GammaFieldId  = Inherited::NextFieldId,
        MatrixFieldId = GammaFieldId  + 1,
        WidthFieldId  = MatrixFieldId + 1,
        HeightFieldId = WidthFieldId  + 1,
        DepthFieldId  = HeightFieldId + 1,
        TableFieldId  = DepthFieldId  + 1,
        NextFieldId   = TableFieldId  + 1
    };

    static const OSG::BitVector GammaFieldMask;
    static const OSG::BitVector MatrixFieldMask;
    static const OSG::BitVector WidthFieldMask;
    static const OSG::BitVector HeightFieldMask;
    static const OSG::BitVector DepthFieldMask;
    static const OSG::BitVector TableFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFReal32            *getSFGamma          (void);
           SFMatrix            *getSFMatrix         (void);
           SFUInt32            *getSFWidth          (void);
           SFUInt32            *getSFHeight         (void);
           SFUInt32            *getSFDepth          (void);
           MFColor3f           *getMFTable          (void);

           Real32              &getGamma          (void);
     const Real32              &getGamma          (void) const;
           Matrix              &getMatrix         (void);
     const Matrix              &getMatrix         (void) const;
           UInt32              &getWidth          (void);
     const UInt32              &getWidth          (void) const;
           UInt32              &getHeight         (void);
     const UInt32              &getHeight         (void) const;
           UInt32              &getDepth          (void);
     const UInt32              &getDepth          (void) const;
           Color3f             &getTable          (const UInt32 index);
           MFColor3f           &getTable          (void);
     const MFColor3f           &getTable          (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setGamma          ( const Real32 &value );
     void setMatrix         ( const Matrix &value );
     void setWidth          ( const UInt32 &value );
     void setHeight         ( const UInt32 &value );
     void setDepth          ( const UInt32 &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  ColorDisplayFilterPtr      create          (void); 
    static  ColorDisplayFilterPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFReal32            _sfGamma;
    SFMatrix            _sfMatrix;
    SFUInt32            _sfWidth;
    SFUInt32            _sfHeight;
    SFUInt32            _sfDepth;
    MFColor3f           _mfTable;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    ColorDisplayFilterBase(void);
    ColorDisplayFilterBase(const ColorDisplayFilterBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~ColorDisplayFilterBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      ColorDisplayFilterBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      ColorDisplayFilterBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const ColorDisplayFilterBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef ColorDisplayFilterBase *ColorDisplayFilterBaseP;

typedef osgIF<ColorDisplayFilterBase::isNodeCore,
              CoredNodePtr<ColorDisplayFilter>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet ColorDisplayFilterNodePtr;

typedef RefPtr<ColorDisplayFilterPtr> ColorDisplayFilterRefPtr;

OSG_END_NAMESPACE

#define OSGCOLORDISPLAYFILTERBASE_HEADER_CVSID "@(#)$Id: FCBaseTemplate_h.h,v 1.38 2005/07/08 06:37:35 vossg Exp $"

#endif /* _OSGCOLORDISPLAYFILTERBASE_H_ */
