/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class ImageForeground!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &ImageForegroundBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 ImageForegroundBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
ImageForegroundPtr ImageForegroundBase::create(void) 
{
    ImageForegroundPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = ImageForegroundPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
ImageForegroundPtr ImageForegroundBase::createEmpty(void) 
{ 
    ImageForegroundPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the ImageForeground::_mfImages field.
inline
MFImagePtr *ImageForegroundBase::getMFImages(void)
{
    return &_mfImages;
}

//! Get the ImageForeground::_mfPositions field.
inline
MFPnt2f *ImageForegroundBase::getMFPositions(void)
{
    return &_mfPositions;
}



//! Get the value of the \a index element the ImageForeground::_mfImages field.
inline
ImagePtr &ImageForegroundBase::getImages(const UInt32 index)
{
    return _mfImages[index];
}

//! Get the ImageForeground::_mfImages field.
inline
MFImagePtr &ImageForegroundBase::getImages(void)
{
    return _mfImages;
}

//! Get the ImageForeground::_mfImages field.
inline
const MFImagePtr &ImageForegroundBase::getImages(void) const
{
    return _mfImages;
}

//! Get the value of the \a index element the ImageForeground::_mfPositions field.
inline
Pnt2f &ImageForegroundBase::getPositions(const UInt32 index)
{
    return _mfPositions[index];
}

//! Get the ImageForeground::_mfPositions field.
inline
MFPnt2f &ImageForegroundBase::getPositions(void)
{
    return _mfPositions;
}

//! Get the ImageForeground::_mfPositions field.
inline
const MFPnt2f &ImageForegroundBase::getPositions(void) const
{
    return _mfPositions;
}

OSG_END_NAMESPACE

#define OSGIMAGEFOREGROUNDBASE_INLINE_CVSID "@(#)$Id: FCBaseTemplate_inl.h,v 1.20 2002/12/04 14:22:22 dirk Exp $"

