/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class GLUTWindow!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEGLUTWINDOWINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGGLUTWindowBase.h"
#include "OSGGLUTWindow.h"


OSG_USING_NAMESPACE

const OSG::BitVector  GLUTWindowBase::IdFieldMask = 
    (TypeTraits<BitVector>::One << GLUTWindowBase::IdFieldId);

const OSG::BitVector GLUTWindowBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Int32           GLUTWindowBase::_sfId
    
*/

//! GLUTWindow description

FieldDescription *GLUTWindowBase::_desc[] = 
{
    new FieldDescription(SFInt32::getClassType(), 
                     "id", 
                     IdFieldId, IdFieldMask,
                     true,
                     (FieldAccessMethod) &GLUTWindowBase::getSFId)
};


FieldContainerType GLUTWindowBase::_type(
    "GLUTWindow",
    "Window",
    NULL,
    (PrototypeCreateF) &GLUTWindowBase::createEmpty,
    GLUTWindow::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(GLUTWindowBase, GLUTWindowPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &GLUTWindowBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &GLUTWindowBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr GLUTWindowBase::shallowCopy(void) const 
{ 
    GLUTWindowPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const GLUTWindow *>(this)); 

    return returnValue; 
}

UInt32 GLUTWindowBase::getContainerSize(void) const 
{ 
    return sizeof(GLUTWindow); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void GLUTWindowBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((GLUTWindowBase *) &other, whichField);
}
#else
void GLUTWindowBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((GLUTWindowBase *) &other, whichField, sInfo);
}
void GLUTWindowBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void GLUTWindowBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

GLUTWindowBase::GLUTWindowBase(void) :
    _sfId                     (Int32(0)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

GLUTWindowBase::GLUTWindowBase(const GLUTWindowBase &source) :
    _sfId                     (source._sfId                     ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

GLUTWindowBase::~GLUTWindowBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 GLUTWindowBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (IdFieldMask & whichField))
    {
        returnValue += _sfId.getBinSize();
    }


    return returnValue;
}

void GLUTWindowBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (IdFieldMask & whichField))
    {
        _sfId.copyToBin(pMem);
    }


}

void GLUTWindowBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (IdFieldMask & whichField))
    {
        _sfId.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void GLUTWindowBase::executeSyncImpl(      GLUTWindowBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (IdFieldMask & whichField))
        _sfId.syncWith(pOther->_sfId);


}
#else
void GLUTWindowBase::executeSyncImpl(      GLUTWindowBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (IdFieldMask & whichField))
        _sfId.syncWith(pOther->_sfId);



}

void GLUTWindowBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<GLUTWindowPtr>::_type("GLUTWindowPtr", "WindowPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(GLUTWindowPtr, OSG_WINDOWGLUTLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(GLUTWindowPtr, OSG_WINDOWGLUTLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGGLUTWINDOWBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGGLUTWINDOWBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGGLUTWINDOWFIELDS_HEADER_CVSID;
}

