#	OpenShot Video Editor is a program that creates, modifies, and edits video files.
#   Copyright (C) 2009  Jonathan Thomas
#
#	This file is part of OpenShot Video Editor (http://launchpad.net/openshot/).
#
#	OpenShot Video Editor is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#
#	OpenShot Video Editor is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with OpenShot Video Editor.  If not, see <http://www.gnu.org/licenses/>.


# Import Blender's python API.  This only works when the script is being
# run from the context of Blender.  Blender contains it's own version of Python
# with this library pre-installed.
import bpy

# Debug Info:
# ./blender -b test.blend -P demo.py
# -b = background mode
# -P = run a Python script within the context of the project file

# Init all of the variables needed by this script.  Because Blender executes
# this script, OpenShot will inject a dictionary of the required parameters
# before this script is executed.
params = {		
			'title' : 'Oh Yeah! OpenShot!',
			'extrude' : 0.1,
			'bevel_depth' : 0.02,
			'spacemode' : 'CENTER',
			'text_size' : 1.5,
			'width' : 1.0,
			'fontname' : 'Bfont',
			
			'color' : [0.8,0.8,0.8],
			'alpha' : 1.0,
			
			'output_path' : '/tmp/',
			'fps' : 24,
			'quality' : 90,
			'file_format' : 'PNG',
			'color_mode' : 'RGBA',
			'horizon_color' : [0.57, 0.57, 0.57],
			'resolution_x' : 1920,
			'resolution_y' : 1080,
			'resolution_percentage' : 100,
			'start_frame' : 20,
			'end_frame' : 25,
			'animation' : True,
		}

#INJECT_PARAMS_HERE

# The remainder of this script will modify the current Blender .blend project
# file, and adjust the settings.  The .blend file is specified in the XML file
# that defines this template in OpenShot.
#----------------------------------------------------------------------------

# Modify the Location of the Wand
sphere_object = bpy.data.objects["Sphere"]
sphere_object.location = [params["start_x"], params["start_y"], params["start_z"]]

# Modify the Start and End keyframes
bpy.data.actions["SphereAction"].fcurves[0].keyframe_points[0].co = (1.0, params["start_x"])
bpy.data.actions["SphereAction"].fcurves[0].keyframe_points[0].handle_left.y = params["start_x"]
bpy.data.actions["SphereAction"].fcurves[0].keyframe_points[0].handle_right.y = params["start_x"]

bpy.data.actions["SphereAction"].fcurves[1].keyframe_points[0].co = (1.0, params["start_y"])
bpy.data.actions["SphereAction"].fcurves[1].keyframe_points[0].handle_left.y = params["start_y"]
bpy.data.actions["SphereAction"].fcurves[1].keyframe_points[0].handle_right.y = params["start_y"]

bpy.data.actions["SphereAction"].fcurves[2].keyframe_points[0].co = (1.0, params["start_z"])
bpy.data.actions["SphereAction"].fcurves[2].keyframe_points[0].handle_left.y = params["start_z"]
bpy.data.actions["SphereAction"].fcurves[2].keyframe_points[0].handle_right.y = params["start_z"]
#################
bpy.data.actions["SphereAction"].fcurves[0].keyframe_points[1].co = (300.0, params["end_x"])
bpy.data.actions["SphereAction"].fcurves[0].keyframe_points[1].handle_left.y = params["end_x"]
bpy.data.actions["SphereAction"].fcurves[0].keyframe_points[1].handle_right.y = params["end_x"]

bpy.data.actions["SphereAction"].fcurves[1].keyframe_points[1].co = (300.0, params["end_y"])
bpy.data.actions["SphereAction"].fcurves[1].keyframe_points[1].handle_left.y = params["end_y"]
bpy.data.actions["SphereAction"].fcurves[1].keyframe_points[1].handle_right.y = params["end_y"]

bpy.data.actions["SphereAction"].fcurves[2].keyframe_points[1].co = (300.0, params["end_z"])
bpy.data.actions["SphereAction"].fcurves[2].keyframe_points[1].handle_left.y = params["end_z"]
bpy.data.actions["SphereAction"].fcurves[2].keyframe_points[1].handle_right.y = params["end_z"]


# Modfiy the Material Keyframe (i.e. the keyframed halo size setting)
bpy.data.actions["Material.001Action"].fcurves[0].keyframe_points[0].co = (1.0, params["start_halo_size"])
bpy.data.actions["Material.001Action"].fcurves[0].keyframe_points[1].co = (300.00, params["end_halo_size"])

# Change the material settings (color, alpha, etc...)
material_object = bpy.data.materials["Material.001"]
material_object.diffuse_color = params["diffuse_color"]
material_object.specular_color = params["specular_color"]
material_object.mirror_color = params["mirror_color"]
material_object.alpha = params["alpha"]

# Change Composite Node settings
sun_glare_node = bpy.data.scenes[0].node_tree.nodes["Glare"]
sun_glare_node.color_modulation = params["sun_glare_color"]
sun_glare_node.glare_type = params["sun_glare_type"]
sun_glare_node.streaks = params["sun_streaks"]
sun_glare_node.angle_offset = params["sun_angle_offset"]

spots_glare_node = bpy.data.scenes[0].node_tree.nodes["Glare.000"]
spots_glare_node.color_modulation = params["spots_glare_color"]

# Change Halo settings
material_object.halo.size = params["start_halo_size"]
material_object.halo.hardness = params["halo_hardness"]
if params["halo_use_lines"] == "Yes":
	material_object.halo.use_lines = True
else:
	material_object.halo.use_lines = False
material_object.halo.line_count = params["halo_line_count"]
if params["halo_use_ring"] == "Yes":
	material_object.halo.use_ring = True
else:
	material_object.halo.use_ring = False
material_object.halo.ring_count = params["halo_ring_count"]
if params["halo_use_star"] == "Yes":
	material_object.halo.use_star = True
else:
	material_object.halo.use_star = False 
material_object.halo.star_tip_count = params["halo_star_tip_count"]


# Set the render options.  It is important that these are set
# to the same values as the current OpenShot project.  These
# params are automatically set by OpenShot
bpy.context.scene.render.filepath = params["output_path"]
bpy.context.scene.render.fps = params["fps"]
#bpy.context.scene.render.quality = params["quality"]
bpy.context.scene.render.file_format = params["file_format"]
bpy.context.scene.render.color_mode = params["color_mode"]
#bpy.data.worlds[0].horizon_color = params["horizon_color"]
bpy.context.scene.render.resolution_x = params["resolution_x"]
bpy.context.scene.render.resolution_y = params["resolution_y"]
bpy.context.scene.render.resolution_percentage = params["resolution_percentage"]
bpy.context.scene.frame_start = params["start_frame"]
bpy.context.scene.frame_end = params["end_frame"]

# Render the current animation to the params["output_path"] folder
bpy.ops.render.render(animation=params["animation"])

