#       .Copyright (C)  1999-2002 TUCOWS.com Inc.
#       .Created:       11/19/1999
#       .Contactid:     <admin@opensrs.org>
#       .Url:           http://www.opensrs.org
#       .Originally Developed by:
#                       Tucows/OpenSRS
#       .Authors:       Igor Kolomiets
#
#
#       This program is free software; you can redistribute it and/or
#       modify it under the terms of the GNU Lesser General Public 
#       License as published by the Free Software Foundation; either 
#       version 2.1 of the License, or (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful, but
#       WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#       Lesser General Public License for more details.
#
#       You should have received a copy of the GNU Lesser General Public
#       License along with this program; if not, write to the Free Software
#       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Simple wrapper to Digest::MD5 library that provides
# calculate() function for creating checksum on a given
# array of values and compare() function to compare
# derived checksum with an expected one.
#
# $Id$

package Core::Checksum;

use strict;
use warnings;
use Digest::MD5 qw(md5_hex);
use Core::Exception;
use vars qw(@ISA @EXPORT_OK);
require Exporter;
@ISA = qw(Exporter);
@EXPORT_OK = qw(calculate compare);
use Data::Dumper;


sub calculate {

    my @args = @_;
    
    my $md5 = md5_hex(@args);
    return $md5;
}

sub compare {
    my $digest = shift;
    my @args = @_;

    if (not defined $digest) {
	throw 'dev', 'Undefined checksum';
    }
   
    $digest = lc $digest;
    $digest =~ s/[^0-9a-f]//g;

    return $digest eq calculate(@args) ? 1 : 0;
}

1;
