dnl
dnl Check for Torque/PBS installation
dnl

dnl @synopsis AX_PBS
dnl
dnl @author Łukasz Cieśnik <lukasz.ciesnik@gmail.com>
dnl @version 2006-08-22
dnl @license GPLWithACException

AC_DEFUN([AX_PBS],[
AC_ARG_WITH([pbs], [AC_HELP_STRING([--with-pbs=<pbs-prefix>],
		[Path to existing PBS installation root])])
AC_SUBST(HAVE_PBS)
AC_SUBST(PBS_CPPFLAGS)
AC_SUBST(PBS_LDFLAGS)
AC_SUBST(PBS_LIBS)

if test "x$with_pbs" != "x"; then
	PBS_CPPFLAGS="$CPPFLAGS -I$with_pbs/include"
	PBS_LDFLAGS="-L$with_pbs/lib"
fi

HAVE_PBS="no"

if test $HAVE_PBS == "no"; then
	HAVE_PBS="yes"
	PBS_LIBS="-lpbs -llog"
	LDFLAGS_save="$LDFLAGS"
	LDFLAGS="$LDFLAGS $PBS_LDFLAGS"
	AC_CHECK_LIB([pbs], [pbs_submit], [:], [HAVE_PBS="no"])
	AC_CHECK_LIB([log], [pbse_to_txt], [:], [HAVE_PBS="no"])
	if test $HAVE_PBS == "yes"; then
		CPPFLAGS_save="$CPPFLAGS"
		CPPFLAGS="$CPPFLAGS $PBS_CPPFLAGS"
		AC_CHECK_HEADERS([pbs_ifl.h pbs_error.h],[],[
				AC_MSG_ERROR([Torque/PBS API headers not found])])
		CPPFLAGS="$CPPFLAGS_save"
	fi
	LDFLAGS="$LDFLAGS_save"
fi

if test $HAVE_PBS == "no"; then
	HAVE_PBS="yes"
	PBS_LIBS="-ltorque"
	LDFLAGS_save="$LDFLAGS"
	LDFLAGS="$LDFLAGS $PBS_LDFLAGS"
	AC_CHECK_LIB([torque], [pbs_submit], [:], [HAVE_PBS="no"])
	AC_CHECK_LIB([torque], [pbse_to_txt], [:], [HAVE_PBS="no"])
	if test $HAVE_PBS == "yes"; then
		CPPFLAGS_save="$CPPFLAGS"
		CPPFLAGS="$CPPFLAGS $PBS_CPPFLAGS"
		AC_CHECK_HEADERS([pbs_ifl.h pbs_error.h],[],[
				AC_MSG_ERROR([Torque/PBS API headers not found])])
		CPPFLAGS="$CPPFLAGS_save"
	fi
	LDFLAGS="$LDFLAGS_save"
fi
])
