\name{computeTestPartialRegression}
\alias{computeTestPartialRegression}
\title{Compute the Partial Regression Test on 2 data sets.}
\description{
This ROT function, called from a Test C++ object, is given 2 samples, a selection
and optionnaly a test level. It then computes the result of a regression
test against the null hypothesis that the selected linear regression coefficients
are significant. It returns the test result for each selected X variable, the
statistics and the p-values. 
}
\usage{
computeTestPartialRegression(outSample, inSample, selection, testLevel = 0.95)
}
\arguments{
  \item{outSample}{The 'out' sample. (n vector)}
  \item{inSample}{The 'in' sample (m-by-n matrix).}
  \item{selection}{The partial variable selection (vector of column indexes)}
  \item{testLevel}{the test level. (scalar in [0:1])}
}
\value{
 A list is returned, containing :
  \item{testResult}{The result. 1 means H0 is not rejected. (vector)}
  \item{threshold}{The threshold applied to the p-value when deciding the outcome of the test.}
  \item{pValues}{The test pValues. (vector)}
}
\author{Pierre-Matthieu Pair, Softia for EDF.}
\examples{
outSample=iris[1:50,1]
inSample=as.matrix(iris[1:50,2:4])
computeTestPartialRegression(outSample, inSample, c(1,2))
}
\keyword{multivariate}