//                                               -*- C++ -*-
/**
 * @file		AnalyticalFunction.hxx
 * @brief		Store information about an analytical function
 *
 * @author	Romuald Conty
 * @date		2006-07-10 11:59:03
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_GUIANALYTICALFUNCTION_HXX
#define OPENTURNS_GUIANALYTICALFUNCTION_HXX

// OT::UI::GUI
#include "Function.hxx"

// Qt
#include <qprocess.h>

// OT
#include "Description.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{

			typedef OT::Base::Type::Description Description;

			class AnalyticalFunction : public Function
			{
					Q_OBJECT

					Q_PROPERTY ( QString output READ getOutput WRITE setOutput )
					Q_PROPERTY ( QString formula READ getFormula WRITE setFormula )

				public:
					/** Default constructor */
					AnalyticalFunction ( QOTObject * parent, const char * name = 0 );

					/** Copy constructor */
					AnalyticalFunction ( const AnalyticalFunction & other, QOTObject* parent );

					/** Destructor */
					~AnalyticalFunction();

					/** The function that actually realizes assignment between objects */
					void assignToMe ( const AnalyticalFunction & other );

					/** AnalyticalFunction result name accessor */
					void setOutput ( const QString& resultName );

					/** AnalyticalFunction result name accessor */
					QString getOutput() const;

					/** AnalyticalFunction formula accessor */
					void setFormula ( QString formula );

					/** AnalyticalFunction formula accessor */
					QString getFormula() const;

					/** AnalyticalFunction NumericalMathFunction accessor */
					NumericalMathFunction getNumericalMathFunction();
				protected:
					Description formula_;
					Description inputs_;
					Description output_;
			};
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */
#endif
