//                                               -*- C++ -*-
/**
 * @file		BlockA.hxx
 * @brief		BlockA is used to input entry variables, analytical function and final variables for StepA
 *
 * @author	Romuald Conty
 * @date		2006-06-13
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef OPENTURNS_GUIBLOCK_A_HXX
#define OPENTURNS_GUIBLOCK_A_HXX

// OT::UI::GUI
#include "Block.hxx"
#include "Chapter.hxx"
#include "EntryVariable.hxx"

// Qt
#include <qtable.h>
#include <qaction.h>

// Visual Components
//#include "QPropertiesTable.hxx"
//#include "QVisualizationTable.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/**
			 * @class		BlockA
			 * @brief		Represents a data Block for the first Step needed to obtain a complete Study
			 *
			 * This class is the graphical representation of a Block which is part of Study's Step.
			 * It used store datas of a BlockA.
			 */
			class BlockA : public Block
			{
					Q_OBJECT

				public:
					/** Default constructor */
					BlockA ( QOTObject * parent, const char* name = 0 );

					//			/** OTFactory constructor */
					//			BlockA( QOTObject * parent );

					/** Destructor */
					virtual ~BlockA();

					QString getFullName() const;

					EntryVariable* getEntryVariable_ptr ( const QString& entryVariableName );

					Chapter* getChapter ( const QString& childrenClassName );

				protected:
					Chapter * A1_;
					Chapter * A11_;
					Chapter * A12_;
					Chapter * A13_;
					Chapter * A2_;
					Chapter * A21_;
					Chapter * A22_;
					Chapter * A221_;
					Chapter * A222_;
			}
			; /* class BlockA */
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_GUIBLOCK_A_HXX */
