//                                               -*- C++ -*-
/**
 * @file		BlockC3.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-09-01 11:40:16
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_UI_GUIBLOCKC3_HXX
#define OPENTURNS_UI_GUIBLOCKC3_HXX

// OT::UI::GUI
#include "Block.hxx"
#include "BlockB.hxx"
#include "ThresholdExceedance.hxx"
#include "CalculationC3.hxx"
#include "FinalVariable.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			class BlockC3 : public Block
			{
					Q_OBJECT
					Q_PROPERTY ( QString blockB READ getBlockB WRITE setBlockB )
					Q_PROPERTY ( QString finalVariable READ getFinalVariable WRITE setFinalVariable )
					Q_PROPERTY ( QString thresold_exceedance READ getThresholdExceedance WRITE setThresholdExceedance )

				public:
					/** Default constructor */
					BlockC3 ( QOTObject* parent, const char* name = 0 );

					/** Destructor */
					~BlockC3();

					/** BlockC3 blockB pointer accessor */
					void setBlockB_ptr ( BlockB* blockB );

					/** BlockC3 blockB pointer accessor */
					BlockB* getBlockB_ptr();

					/** BlockC3 blockB name accessor */
					bool setBlockB ( const QString& blockBName );

					/** BlockC3 blockB name accessor */
					QString getBlockB() const;

					/** BlockC3 final variable pointer accessor */
					void setFinalVariable_ptr ( FinalVariable* finalVariable );

					/** BlockC3 final variable pointer accessor */
					FinalVariable* getFinalVariable_ptr();

					/** BlockC3 final variable name accessor */
					bool setFinalVariable ( const QString& finalVariable );

					/** BlockC3 final variable name accessor */
					QString getFinalVariable() const;

					/** BlockC3 threshold exceedance's pointer accessor */
					void setThresholdExceedance_ptr ( ThresholdExceedance* thresholdExceedance );

					/** BlockC3 threshold exceedance's pointer accessor */
					ThresholdExceedance * getThresholdExceedance_ptr();

					/** BlockC3 threshold exceedance's name accessor */
					bool setThresholdExceedance ( const QString& thresholdExceedanceName );

					/** BlockC3 threshold exceedance's name accessor */
					QString getThresholdExceedance() const;

					QString getFullName() const;
				protected:
					BlockB* blockB_;
					FinalVariable* finalVariable_;
					ThresholdExceedance * thresholdExceedance_;
					//CalculationC3 * calculationC3_;
			};

		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif
