//                                               -*- C++ -*-
/**
 * @file		CalculationC2.cxx
 * @brief
 *
 * @author	Francois Suau / Romuald Conty
 * @date		2006-09-26 15:22:04
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "CalculationC2.hxx"

// OT::UI::GUI
#include "Parameter.hxx"
#include "BlockC2.hxx"
#include "Result.hxx"

// OT
#include "OT.hxx"
#include "NumericalMathFunction.hxx"
#include "QuadraticCumul.hxx"
#include "CorrelationMatrix.hxx"
#include "Normal.hxx"
#include "NumericalPoint.hxx"
#include "RandomVector.hxx"
#include "Exception.hxx"

// Qt
#include <qdatetime.h>

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{

			typedef OT::Uncertainty::Model::RandomVector RandomVector;
			typedef OT::Uncertainty::Algorithm::QuadraticCumul QuadraticCumul;

			typedef OT::Base::Stat::NumericalSample NumericalSample;

			CalculationC2::CalculationC2 ( QOTObject* parent, const char* name ) : Calculation ( parent, name )
			{
				setTitle ( "Central dispersion" );

				connect ( this, SIGNAL ( postprocessing() ), this, SLOT ( fillResults() ) );
				connect ( this, SIGNAL ( preprocessing() ), this, SLOT ( flushResults() ) );

				centralDispersionMethodProperty_ = new CentralDispersionMethodProperty ( this, "method" );
				centralDispersionMethodProperty_->setDefaultChoice();
			}

			CalculationC2::~CalculationC2()
			{}

			int CalculationC2::processing()
			{
				int errorCode = 0;
				try
				{
					QDateTime startDateTime ( QDateTime::currentDateTime() );
					BlockC2* blockC2 = ( BlockC2* ) parent();
					FinalVariable* finalVariable = blockC2->getFinalVariable_ptr();
					BlockB* blockB = blockC2->getBlockB_ptr();

					RandomVector outputVector = createOutputRandomVector ( finalVariable, blockB );

					CentralDispersionResult result;

					QString method = centralDispersionMethodProperty_->getMethod();
					if ( method == "quadratic cumul" )
					{
						// We create a quadraticCumul algorithm
						QuadraticCumul quadraticCumul ( outputVector );
						qDebug ( ( std::string ( "quadraticCumul=" ) + quadraticCumul.str() ).c_str() );

						if ( centralDispersionMethodProperty_->getQuadraticCumulOrder() == 1 )
						{
							result.mean = quadraticCumul.getMeanFirstOrder();
						}
						else if ( centralDispersionMethodProperty_->getQuadraticCumulOrder() == 2 )
						{
							result.mean = quadraticCumul.getMeanSecondOrder();
						}
						result.covariance = quadraticCumul.getCovariance();
						std::cout << "DEBUG " << quadraticCumul.str() << std::endl;

					}
					else if ( method == "sampling" )
					{
						UnsignedLong size = centralDispersionMethodProperty_->getSamplingSampleSize();
						NumericalSample sample = outputVector.getNumericalSample ( size );
						result.mean = sample.computeMean();
						result.covariance = sample.computeCovariance();
					}

					new Result ( this, method.ascii(), startDateTime, QDateTime::currentDateTime(), result );

				}
				catch ( ... )
				{
					//std::cerr << ex << std::endl;
					errorCode = -1;
				}

				return errorCode;
			}

			void CalculationC2::fillResults()
			{
				emit updated();
			}

			void CalculationC2::flushResults()
			{
				emit updated();
			}

		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */
