//                                               -*- C++ -*-
/**
 * @file		CentralDispersionMethodProperty.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-12 11:46:48
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "CentralDispersionMethodProperty.hxx"

// OT::UI::GUI
#include "UnsignedLongProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			CentralDispersionMethodProperty::CentralDispersionMethodProperty ( QObject* parent, const char* name ) : QOTProperty ( QOTProperty::MultipleChoice, parent, name )
			{
				quadraticCumulOrder_ = 1;
				samplingSampleSize_ = 10000;
			}

			CentralDispersionMethodProperty::~CentralDispersionMethodProperty()
			{}


			QString CentralDispersionMethodProperty::getValue()
			{
				return method_;
			}

			QStringList CentralDispersionMethodProperty::getChoices()
			{
				QStringList choices;
				choices << "quadratic cumul" << "sampling";
				return choices;
			}

			bool CentralDispersionMethodProperty::setValue ( QString value )
			{
				if ( method_ != value )
				{
					method_ = value;
					QOTProperties subproperties = getSubproperties ( false );
					subproperties.setAutoDelete ( true );
					subproperties.clear();

					if ( method_ == "quadratic cumul" )
					{
						propertyUpdated ( new UnsignedLongProperty ( &quadraticCumulOrder_, true, this, "order" ) );
					}
					else if ( method_ == "sampling" )
					{
						propertyUpdated ( new UnsignedLongProperty ( &samplingSampleSize_, true, this, "sample size" ) );
					}
					return true;
				}
				return false;
			}

			void CentralDispersionMethodProperty::propertyUpdated ( QOTProperty* subproperty )
			{
				emit updated ( subproperty );
			}

			QString CentralDispersionMethodProperty::getMethod() const
			{
				return method_;
			}

			UnsignedLong CentralDispersionMethodProperty::getQuadraticCumulOrder() const
			{
				return quadraticCumulOrder_;
			}

			UnsignedLong CentralDispersionMethodProperty::getSamplingSampleSize() const
			{
				return samplingSampleSize_;
			}

		}

	}

}
