//                                               -*- C++ -*-
/**
 * @file		ComparisonOperatorProperty.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-11 11:38:11
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "ComparisonOperatorProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			typedef OT::Base::Common::Less Less;
			typedef OT::Base::Common::Greater Greater;
			typedef OT::Base::Common::GreaterOrEqual GreaterOrEqual;
			typedef OT::Base::Common::LessOrEqual LessOrEqual;
			typedef OT::Base::Common::Equal Equal;

			ComparisonOperatorProperty::ComparisonOperatorProperty ( ComparisonOperator* comparisonOperator, QObject* parent, const char* name ) : QOTProperty ( QOTProperty::MultipleChoice, parent, name )
			{
				comparisonOperator_ = comparisonOperator;
				comparisonOperatorSymbol_ = "";
			}


			ComparisonOperatorProperty::~ComparisonOperatorProperty()
			{}


			QString ComparisonOperatorProperty::getValue()
			{
				return comparisonOperatorSymbol_;
			}

			QStringList ComparisonOperatorProperty::getChoices()
			{
				QStringList choices;
				choices << "<" << "<=" << ">=" << ">";
				return choices;
			}

			bool ComparisonOperatorProperty::setValue ( QString value )
			{
				if ( value != comparisonOperatorSymbol_ )
				{
					comparisonOperatorSymbol_ = value;

					if ( comparisonOperatorSymbol_ == "<" )
					{
						( *comparisonOperator_ ) = Less();
					}
					else if ( comparisonOperatorSymbol_ == "<=" )
					{
						( *comparisonOperator_ ) = LessOrEqual();
					}
					else if ( comparisonOperatorSymbol_ == ">=" )
					{
						( *comparisonOperator_ ) = GreaterOrEqual();
					}
					else if ( comparisonOperatorSymbol_ == ">" )
					{
						( *comparisonOperator_ ) = Greater();
					}
					else if ( comparisonOperatorSymbol_ == "=" )
					{
						( *comparisonOperator_ ) = Equal();
					}
					return true;
				}
				return false;
			}

		}

	}

}
