//                                               -*- C++ -*-
/**
 * @file		ComparisonOperatorProperty.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-11 11:38:11
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_UI_GUICOMPARISONOPERATORPROPERTY_HXX
#define OPENTURNS_UI_GUICOMPARISONOPERATORPROPERTY_HXX

// OT::UI::GUI
#include "QOTProperty.hxx"

// OT
#include "ComparisonOperator.hxx"

#include "Less.hxx"
#include "Greater.hxx"
#include "GreaterOrEqual.hxx"
#include "LessOrEqual.hxx"
#include "Equal.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			typedef OT::Base::Common::ComparisonOperator ComparisonOperator;

			class ComparisonOperatorProperty : public QOTProperty
			{
					Q_OBJECT
				public:
					ComparisonOperatorProperty ( ComparisonOperator* comparisonOperator, QObject* parent, const char* name );

					~ComparisonOperatorProperty();

					virtual QString getValue();
					virtual QStringList getChoices();
					virtual bool setValue ( QString value );

				protected:
					ComparisonOperator* comparisonOperator_;
					QString comparisonOperatorSymbol_;

			};

		}

	}

}

#endif
