//                                               -*- C++ -*-
/**
 * @file		EntryVariableType.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-09-19 16:00:57
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
//Header
#include "EntryVariableType.hxx"

// OT::UI::GUI
#include "BlockB.hxx"

// OT
#include "NumericalPoint.hxx"
#include "Normal.hxx"
#include "DistributionImplementation.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{

			typedef OT::Base::Type::NumericalPoint NumericalPoint;
			typedef OT::Uncertainty::Distribution::Normal Normal;
			typedef OT::Base::Stat::CorrelationMatrix CorrelationMatrix;

			EntryVariableType::EntryVariableType ( QOTObject* parent, const char* name, EntryVariable * entryVariable ) : Content ( parent, name )
			{
				delete actionRemove_;
				delete actionCopy_;

				entryVariable_ = entryVariable;
				Q_CHECK_PTR ( entryVariable_ );
				connect ( entryVariable_, SIGNAL ( updated ( QOTObject* ) ), this, SIGNAL ( updated ( QOTObject* ) ) );
				connect ( entryVariable_, SIGNAL ( destroyed() ), this, SLOT ( destroy() ) );

				type_ = VariableTypeProperty::Deterministic;
				QOTProperty* variableTypeProperty = new VariableTypeProperty ( &type_, this, "type" );
				variableTypeProperty->setDefaultChoice();
				connect ( variableTypeProperty, SIGNAL ( updated() ), this, SLOT ( typeChanged() ) );

				// Fake Initialization
				NumericalPoint mean ( 1, 0. );
				NumericalPoint sigma ( 1, 1. );

				distribution_ = new Distribution ( Normal ( mean, sigma, CorrelationMatrix ( 1 ) ), "distribution" );
				//DistributionImplementation();

				distributionProperty_ = NULL;
			}

			EntryVariableType::EntryVariableType ( QOTObject* parent, const char* name ) : Content ( parent, name )
			{
				entryVariable_ = NULL;
			}

			EntryVariableType::~EntryVariableType()
			{}

			EntryVariable* EntryVariableType::getEntryVariable_ptr()
			{
				return entryVariable_;
			}

			QString EntryVariableType::getEntryVariable() const
			{
				QString entryVariableName = "";
				if ( entryVariable_ != NULL )
				{
					entryVariableName = entryVariable_->getName();
				}
				return entryVariableName;
			}

			void EntryVariableType::setEntryVariable ( const QString& entryVariable )
			{
				if ( entryVariable_ == NULL )
				{
					QObject * otParent = this->findParent ( "OpenTURNS::UI::GUI::BlockB" );
					Q_CHECK_PTR ( otParent );
					if ( otParent != NULL )
					{
						BlockB * blockB = ( BlockB* ) otParent;
						entryVariable_ = blockB->getBlockA_ptr() ->getEntryVariable_ptr ( entryVariable );
						Q_CHECK_PTR ( entryVariable_ );
					}
				}
				else
				{
					qWarning ( "You cannot reset entry variable pointer in a EntryVariableType !" );
				}
			}

			VariableTypeProperty::VariableType EntryVariableType::getVariableType() const
			{
				return type_;
			}

			QString EntryVariableType::getType() const
			{
				if ( type_ == VariableTypeProperty::Stochastic )
				{
					return "Stochastic";
				}
				else
				{
					return "Deterministic";
				}
			}

			Distribution EntryVariableType::getDistribution() const
			{
				return Distribution ( *distribution_ );
			}

			void EntryVariableType::typeChanged()
			{
				if ( distributionProperty_ != NULL )
				{
					delete distributionProperty_;
					distributionProperty_ = NULL;
				}
				if ( type_ == VariableTypeProperty::Stochastic )
				{
					distributionProperty_ = new DistributionProperty ( distribution_, this, "distribution" );
					distributionProperty_->setDefaultChoice();
				}
			}

			bool EntryVariableType::isDeterministic() const
			{
				return ( type_ == VariableTypeProperty::Deterministic );
			}

		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

