//                                               -*- C++ -*-
/**
 * @file		EntryVariableType.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-09-19 10:32:00
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_GUIENTRYVARIABLETYPE_HXX
#define OPENTURNS_GUIENTRYVARIABLETYPE_HXX

// OT::UI::GUI
#include "Content.hxx"
#include "EntryVariable.hxx"

#include "VariableTypeProperty.hxx"
#include "DistributionProperty.hxx"

// Qt
#include <qvariant.h>

// OT
#include "Distribution.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			class EntryVariableType : public Content
			{
					Q_OBJECT
					Q_PROPERTY ( QString entry_variable READ getEntryVariable WRITE setEntryVariable )

				public:
					/** Default constructor */
					EntryVariableType ( QOTObject* parent, const char* name, EntryVariable * entryVariable );

					/** Special constructor (QOTFactory) */
					EntryVariableType ( QOTObject* parent, const char* name = 0 );

					/** Destructor */
					~EntryVariableType();

					/** EntryVariableType linked entry variable pointer accessor */
					EntryVariable * getEntryVariable_ptr();

					/** EntryVariableType linked entry variable name accessor */
					QString getEntryVariable() const;

					/** EntryVariableType linked entry variable name accessor */
					void setEntryVariable ( const QString& entryVariable );

					VariableTypeProperty::VariableType getVariableType() const;
					QString getType() const;

					bool isDeterministic() const;

					Distribution getDistribution() const;

				protected:
					EntryVariable * entryVariable_;

					VariableTypeProperty::VariableType type_;
					Distribution* distribution_;

					DistributionProperty* distributionProperty_;

				protected slots:
					void typeChanged();
			};
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif
