//                                               -*- C++ -*-
/**
 * @file		ExternalCode.cxx
 * @brief		Store information about an coupling function
 *
 * @author	Romuald Conty
 * @date		2006-08-18 16:11:43
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "ExternalCode.hxx"

// OT::UI::GUI

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			ExternalCode::ExternalCode ( QOTObject * parent, const char * name ) : Function ( parent, name )
			{
				wrapperProperty_ = new WrapperProperty ( &numericalMathFunction_, this, "wrapper" );
			}

			ExternalCode::ExternalCode ( const ExternalCode & other, QOTObject* parent ) : Function ( parent )
			{
				wrapperProperty_ = new WrapperProperty ( &numericalMathFunction_, this, "wrapper" );
				assignToMe ( other );
			}

			ExternalCode::~ExternalCode()
			{}

			void ExternalCode::assignToMe ( const ExternalCode & other )
			{
				setWrapperName ( other.getWrapperName() );
				Content::assignToMe ( other );
			}

			/** ExternalCode wrapper file name accessor */
			QString ExternalCode::getWrapperName() const
			{
				return wrapperProperty_->getValue();
			}

			/** ExternalCode wrapper file name accessor */
			void ExternalCode::setWrapperName ( const QString& wrapperName )
			{
				if ( wrapperName.stripWhiteSpace() != getWrapperName() )
				{
					wrapperProperty_->setValue ( wrapperName.stripWhiteSpace() );
					emit updated();
				}
			}

			/** ExternalCode NumericalMathFunction accessor */
			NumericalMathFunction ExternalCode::getNumericalMathFunction()
			{
				return numericalMathFunction_;
			}

		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

