//                                               -*- C++ -*-
/**
 * @file		ExternalCode.hxx
 * @brief		Store information about an coupling function
 *
 * @author	Romuald Conty
 * @date		2006-08-18 16:11:43
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_GUICOUPLINGFUNCTION_HXX
#define OPENTURNS_GUICOUPLINGFUNCTION_HXX

// OT::UI::GUI
#include "Function.hxx"
#include "WrapperProperty.hxx"

// OT
#include "OT.hxx"
#include "NumericalMathFunction.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			typedef OT::Base::Func::NumericalMathFunction NumericalMathFunction;

			class ExternalCode : public Function
			{
					Q_OBJECT

					Q_PROPERTY ( QString wrapper_name READ getWrapperName WRITE setWrapperName )

				public:

					/** Default constructor */
					ExternalCode ( QOTObject* parent, const char* name = 0 );

					/** Copy constructor */
					ExternalCode ( const ExternalCode & other, QOTObject* parent );

					/** Destructor */
					~ExternalCode();

					/** ExternalCode wrapper file name accessor */
					QString getWrapperName() const;

					/** ExternalCode wrapper file name accessor */
					void setWrapperName ( const QString& wrapperName );

					/** ExternalCode NumericalMathFunction accessor */
					NumericalMathFunction getNumericalMathFunction();

				protected:

					/** The function that actually realizes assignment between entry variables */
					void assignToMe ( const ExternalCode & other );

					NumericalMathFunction numericalMathFunction_;
					WrapperProperty* wrapperProperty_;
			};
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif
