//                                               -*- C++ -*-
/**
 * @file		HessianCalculationProperty.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-14 11:35:03
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "HessianCalculationProperty.hxx"

// Qt
#include <qstringlist.h>

// OT::UI::GUI
#include "NumericalScalarProperty.hxx"

// OT
#include "CenteredFiniteDifferenceHessian.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			typedef OT::Base::Diff::CenteredFiniteDifferenceHessian CenteredFiniteDifferenceHessian;

			HessianCalculationProperty::HessianCalculationProperty ( NumericalMathFunction* numericalMathFunction, QObject* parent, const char* name )
					: QOTProperty ( QOTProperty::MultipleChoice, parent, name )
			{
				numericalMathFunction_ = numericalMathFunction;
				value_ = "";
			}

			HessianCalculationProperty::~HessianCalculationProperty()
			{}


			QString HessianCalculationProperty::getValue()
			{
				return tr ( value_ );
			}

			bool HessianCalculationProperty::setValue ( QString value )
			{
				if ( value != tr ( value_ ) )
				{
					QOTProperties subproperties = this->getSubproperties ( true );
					subproperties.setAutoDelete ( true );
					subproperties.clear();

					if ( value == tr ( "native" ) )
					{
						value_ = "native";
					}
					else if ( value == tr ( "centered finite difference" ) )
					{
						value_ = "centered finite difference";
						step_ = 0.5;
						autoconnect ( new NumericalScalarProperty ( &step_, true, this, "step" ) );
					}
					generateHessian();
					return true;
				}
				return false;
			}

			QStringList HessianCalculationProperty::getChoices()
			{
				QStringList choices;
				if ( numericalMathFunction_->getHessianImplementation() ->isActualImplementation() )
				{
					choices << tr ( "native" );
				}
				choices << tr ( "centered finite difference" );
				return choices;
			}

			void HessianCalculationProperty::autoconnect ( QOTProperty* subproperty )
			{
				connect ( subproperty, SIGNAL ( updated() ), this, SLOT ( generateHessian() ) );
				propertyUpdated ( subproperty );
			}

			void HessianCalculationProperty::propertyUpdated ( QOTProperty* subproperty )
			{
				emit updated ( subproperty );
			}

			void HessianCalculationProperty::generateHessian()
			{
				if ( value_ == "native" )
				{
					numericalMathFunction_->setHessianImplementation ( numericalMathFunction_->getInitialHessianImplementation() );
				}
				else if ( value_ == "centered finite difference" )
				{
					numericalMathFunction_->setHessianImplementation ( new CenteredFiniteDifferenceHessian ( step_, numericalMathFunction_->getEvaluationImplementation() ) );
				}
				emit updated();
			}
		}

	}

}
