//                                               -*- C++ -*-
/**
 * @file		QConcole.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-03 19:12:32
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_UI_GUIQOTCONSOLE_HXX
#define OPENTURNS_UI_GUIQOTCONSOLE_HXX

// OT::UI::GUI
#include "QStreamRedirect.hxx"

// Qt
#include <qtextedit.h>

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{

			class QConsole : public QTextEdit
			{
					Q_OBJECT
				public:
					QConsole ( QWidget* parent, const char *name = 0 );

					~QConsole();

				public slots:
					void writeText ( const QString& text );

					void setIostreamRedirect ( bool ioRedirect );

				protected slots:
					void writeStdOut ( const QString& stdout );
					void writeStdError ( const QString& stderr );

				private:
					QStreamRedirect* cout_;
					QStreamRedirect* cerr_;

					bool ioRedirect_;
			};

		}
	}
}

#endif
