//                                               -*- C++ -*-
/**
 * @file			QOTAction.cxx
 * @brief
 *
 * @author		Romuald Conty
 * @date			2006-07-18 11:53:30
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#include "QOTAction.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			QOTAction::QOTAction ( const QIconSet & icon, const QString & menuText, QKeySequence accel, QObject * parent, const char * name ) : QAction ( icon, menuText, accel, parent, name )
			{
				connect ( this, SIGNAL ( activated() ) , this, SLOT ( activatedExt() ) );
			}

			QOTAction::QOTAction ( const QString & menuText, QKeySequence accel, QObject * parent, const char * name ) : QAction ( menuText, accel, parent, name )
			{
				const QString icon = name;
				if ( !icon.isEmpty() )
					setIconSet ( QPixmap::fromMimeSource ( icon + ".png" ) );
				connect ( this, SIGNAL ( activated() ) , this, SLOT ( activatedExt() ) );
			}

			void QOTAction::activatedExt()
			{
				emit activated ( this );
			}

			QOTAction::~QOTAction()
			{
			}
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

