//                                               -*- C++ -*-
/**
 * @file			QOTAction.hxx
 * @brief
 *
 * @author		Romuald Conty
 * @date			2006-07-18 11:53:08
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_GUIQACTIONEXT_HXX
#define OPENTURNS_GUIQACTIONEXT_HXX

#include <qaction.h>

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			class QOTAction : public QAction
			{
					Q_OBJECT
				public:
					QOTAction ( const QIconSet & icon, const QString & menuText, QKeySequence accel, QObject * parent, const char * name = 0 );
					QOTAction ( const QString & menuText, QKeySequence accel, QObject * parent, const char * name = 0 );

					~QOTAction();

				private slots:
					void activatedExt();

				signals:
					void activated ( QAction* sender );
			};

			typedef QPtrList<QOTAction> QOTActions;
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif
