//                                               -*- C++ -*-
/**
 * @file		QOTFactory.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-09-11 14:52:25
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
//Header
#include "QOTFactory.hxx"

// Qt
#include <qmetaobject.h>

// OT::UI::GUI
#include "StepA.hxx"
#include "BlockA.hxx"
#include "EntryVariable.hxx"
#include "AnalyticalFunction.hxx"
#include "ExternalCode.hxx"
#include "ResponseSurfaceFunction.hxx"
#include "FinalVariable.hxx"
#include "DeterministicCriterion.hxx"
#include "CentralDispersion.hxx"
#include "ThresholdExceedance.hxx"
#include "StepB.hxx"
#include "BlockB.hxx"
#include "EntryVariableType.hxx"

#include "StepC2.hxx"
#include "BlockC2.hxx"
#include "CalculationC2.hxx"
#include "StepC3.hxx"
#include "BlockC3.hxx"
#include "CalculationC3.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{

			QOTFactory::QOTFactory ( Study * parent ) : QXmlDefaultHandler()
			{
				parent_ = parent;
				Q_CHECK_PTR ( parent_ );
				objectList_ = new QOTObjectList();
				objectList_->clear();

				parameters_.clear();
				parametersName_ = "";
			}

			QOTFactory::~QOTFactory()
			{
				delete objectList_;
			}

			bool QOTFactory::loadFromXml ( QIODevice * dev )
			{
				QXmlInputSource source ( dev );
				QXmlSimpleReader reader;

				reader.setContentHandler ( this );
				uint i = 0;
				while ( reader.parse ( &source, true ) )
				{
					i++;
				}
				if ( i > 0 )
					return true;
				else
					return false;
			}

			bool QOTFactory::startElement ( const QString & namespaceURI, const QString & localName, const QString & qName, const QXmlAttributes & atts )
			{
				QOTObject * object = NULL;
				QString objectClassName = localName;
				QString objectLongClassName = "OpenTURNS::UI::GUI::" + localName;
				//				QString parentClassName = objectList->last()->getShortClassName();
				if ( objectClassName == "Study" )
				{
					object = parent_;
				}
				else if ( objectClassName == "StepA" )
				{
					object = parent_->getStepA();
				}
				else if ( objectClassName == "BlockA" )
				{
					object = new BlockA ( objectList_->last() );
				}
				else if ( objectClassName == "EntryVariable" )
				{
					BlockA * blockA = ( BlockA* ) objectList_->last();
					object = new EntryVariable ( blockA->getChapter ( objectLongClassName ) );
				}
				else if ( objectClassName == "AnalyticalFunction" )
				{
					BlockA * blockA = ( BlockA* ) objectList_->last();
					object = new AnalyticalFunction ( blockA->getChapter ( objectLongClassName ) );
				}
				else if ( objectClassName == "ExternalCode" )
				{
					BlockA * blockA = ( BlockA* ) objectList_->last();
					object = new ExternalCode ( blockA->getChapter ( objectLongClassName ) );
				}
				else if ( objectClassName == "ResponseSurfaceFunction" )
				{
					BlockA * blockA = ( BlockA* ) objectList_->last();
					object = new ResponseSurfaceFunction ( blockA->getChapter ( objectLongClassName ) );
				}
				else if ( objectClassName == "FinalVariable" )
				{
					BlockA * blockA = ( BlockA* ) objectList_->last();
					object = new FinalVariable ( blockA->getChapter ( objectLongClassName ) );
				}
				else if ( objectClassName == "DeterministicCriterion" )
				{
					BlockA * blockA = ( BlockA* ) objectList_->last();
					object = new DeterministicCriterion ( blockA->getChapter ( objectLongClassName ) );
				}
				else if ( objectClassName == "CentralDispersion" )
				{
					BlockA * blockA = ( BlockA* ) objectList_->last();
					object = new CentralDispersion ( blockA->getChapter ( objectLongClassName ) );
				}
				else if ( objectClassName == "ThresholdExceedance" )
				{
					BlockA * blockA = ( BlockA* ) objectList_->last();
					object = new ThresholdExceedance ( blockA->getChapter ( objectLongClassName ) );
				}
				// Step B
				else if ( objectClassName == "StepB" )
				{
					object = parent_->getStepB();
				}
				else if ( objectClassName == "BlockB" )
				{
					object = new BlockB ( objectList_->last() );
				}
				else if ( objectClassName == "EntryVariableType" )
				{
					QString entryVariableTypeName = "";
					for ( int i = 0; i < atts.count(); i++ )
					{
						const QString propertyName = atts.localName ( i );
						const QString propertyValueString = atts.value ( i );
						if ( propertyName == "name" )
						{
							entryVariableTypeName = propertyValueString;
						}
					}
					BlockB * blockB = ( BlockB* ) objectList_->last();
					object = blockB->getEntryVariableType_ptr ( entryVariableTypeName );
				}
				// Step C
				else if ( objectClassName == "StepC2" )
				{
					object = parent_->getStepC2();
				}
				else if ( objectClassName == "BlockC2" )
				{
					object = new BlockC2 ( objectList_->last() );
				}
				else if ( objectClassName == "CalculationC2" )
				{
					object = new CalculationC2 ( objectList_->last() );
				}
				else if ( objectClassName == "StepC3" )
				{
					object = parent_->getStepC3();
				}
				else if ( objectClassName == "BlockC3" )
				{
					object = new BlockC3 ( objectList_->last() );
				}
				else if ( objectClassName == "CalculationC3" )
				{
					object = new CalculationC3 ( objectList_->last() );
				}

				// Subproperties
				else if ( objectClassName == "Property" )
				{
					parameters_.clear();
					parametersName_ = atts.value ( "name" );
				}
				else if ( objectClassName == "Subproperty" )
				{
					Parameter p;
					for ( int i = 0; i < atts.count(); i++ )
					{
						p.insert ( atts.localName ( i ), atts.value ( i ) );
					}
					parameters_.append ( p );
				}


				if ( object != NULL )
				{
					objectList_->append ( object );

					for ( int i = 0; i < object->metaObject() ->numProperties ( true ); i++ )
					{
						const QMetaProperty * metaProperty = object->metaObject() ->property ( i, true );
						const QString propertyName = metaProperty->name();
						const QString propertyType = metaProperty->type();

						if ( metaProperty->writable() )
						{
							int attributesIndex = atts.index ( propertyName );
							//qDebug( QString( "Property : " + propertyName + " index : " + QString::number( i ) ) );
							if ( attributesIndex != -1 )
							{
								QString propertyValueString = atts.value ( attributesIndex );
								QVariant propertyValueVariant = QVariant ( propertyValueString );

								if ( metaProperty->isEnumType() )
								{
									int propertyValueInt = 0;
									QStrList c_strings = metaProperty->enumKeys();
									for ( uint j = 0; j < c_strings.count(); ++j )
									{
										if ( QString ( c_strings.at ( j ) ) == propertyValueString )
										{
											propertyValueInt = j;
										}
									}
									propertyValueVariant = QVariant ( propertyValueInt );
								}
								else if ( propertyType == "QValueList<QVariant>" )
								{
									QValueList<QVariant> propertyValueList;
									propertyValueList.append ( propertyValueVariant );
									propertyValueVariant = propertyValueList;
								}
								bool ok = object->setProperty ( propertyName, propertyValueVariant );
								if ( !ok )
								{
									qWarning ( QString ( "Unable to set property : " + propertyName + " (type: " + propertyType + ") in " + objectClassName ).ascii() );
								}
							}
							else
							{
								if ( propertyType != "QValueList<QVariant>" )
								{
									qDebug ( QString ( "Attribute : " + propertyName + " not found for object : " + objectClassName + " with type : " + propertyType ).ascii() );
								}
							}
						}
					}
				} /* if ( object != NULL ) */
				return true;
			}

			bool QOTFactory::endElement ( const QString & namespaceURI, const QString & localName, const QString & qName )
			{
				if ( localName == "Property" )
				{
					if ( parametersName_ != "" )
					{
						objectList_->last() ->setProperty ( parametersName_, parameters_ );
					}
					parametersName_ = "";
					parameters_.clear();
				}
				else if ( objectList_->last() ->getShortClassName() == localName )
				{
					objectList_->removeLast();
				}
				return true;
			}

		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

