//                                               -*- C++ -*-
/**
 * @file    QOTListViewItem.cxx
 * @brief   QOTItem based QListViewITem.
 *
 * @author  Romuald Conty
 * @date    2006-07-17 11:41:13
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "QOTListViewItem.hxx"

//Qt
#include <qpixmap.h>

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/** Constructor */
			QOTListViewItem::QOTListViewItem ( QListView * parent, QOTObject * link ) : QOTItem ( link ), QListViewItem ( parent )
			{
				Q_CHECK_PTR ( link );
				setText ( 0, link->getFullName() );
				setPixmap ( 0, QPixmap::fromMimeSource ( link->getShortClassName() + ".png" ) );
				setRenameEnabled ( 0, link->getRenameEnabled() );
				if ( link->children() != NULL )
					qotObjectChildCount = link->children() ->count();
				else
					qotObjectChildCount = 0;
			}

			/** Constructor */
			QOTListViewItem::QOTListViewItem ( QOTListViewItem * parent, QOTObject * link ) : QOTItem ( link ), QListViewItem ( parent )
			{
				Q_CHECK_PTR ( link );
				setText ( 0, link->getFullName() );
				setPixmap ( 0, QPixmap::fromMimeSource ( link->getShortClassName() + ".png" ) );
				setRenameEnabled ( 0, link->getRenameEnabled() );
				if ( link->children() != NULL )
					qotObjectChildCount = link->children() ->count();
				else
					qotObjectChildCount = 0;
				connect ( link, SIGNAL ( destroyed() ), parent, SLOT ( update() ) );
			}

			/** Destructor */
			QOTListViewItem::~QOTListViewItem()
			{}

			void QOTListViewItem::update()
			{
				setText ( 0, QOTItem::getQOTObject() ->getFullName() );
				uint childCount = 0;
				if ( QOTItem::getQOTObject() ->children() != NULL )
				{
					childCount = QOTItem::getQOTObject() ->children() ->count();
				}
				if ( qotObjectChildCount != childCount )
				{
					qotObjectChildCount = childCount;
					emit childrenChanged ( this );
				}
				else
				{
					/** @todo find a better solution !!! */
					emit childrenChanged ( this );
				}
			}

			void QOTListViewItem::destroy()
			{
				update();
				QOTItem::destroy();
			}
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

