//                                               -*- C++ -*-
/**
 * @file		QOTListViewItem.hxx
 * @brief		QOTItem based QListViewITem.
 *
 * @author	Romuald Conty
 * @date		2006-07-17 11:27:38
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_GUIQOTLISTVIEWITEM_HXX
#define OPENTURNS_GUIQOTLISTVIEWITEM_HXX

// Qt
#include <qlistview.h>

// OT::UI::GUI
#include "QOTItem.hxx"
#include "QOTObject.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			class QOTListViewItem : public QOTItem, public QListViewItem
			{
					Q_OBJECT

				public:
					/** Constructor */
					QOTListViewItem ( QListView * parent, QOTObject * link );

					/** Constructor */
					QOTListViewItem ( QOTListViewItem * parent, QOTObject * link );

					/** Destructor */
					virtual ~QOTListViewItem();

				public slots:
					void update();
					virtual void destroy();

				signals:
					void childrenChanged ( QOTListViewItem* parent );

				protected:
					uint qotObjectChildCount;
			}
			; /* class QOTListViewItem */
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_GUIQOTLISTVIEWITEM_HXX */
