//                                               -*- C++ -*-
/**
 * @file		QOTProperty.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-12-18 11:29:13
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#include "QOTProperty.hxx"

// OT
#include "QOTObject.hxx"


namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			QOTProperty::QOTProperty ( const QOTProperty::PropertyType type, QObject *parent, const char *name )
					: QObject ( parent, name )
			{
				uuid_ = QUuid::createUuid ();

				type_ = type;
				name_ = QString ( name );

				connect ( this, SIGNAL ( updated() ), this, SLOT ( updatedExt() ) );
				if ( parent->inherits ( "OpenTURNS::UI::GUI::QOTProperty" ) )
				{
					QOTProperty * otParent = ( QOTProperty* ) parent;
					connect ( this, SIGNAL ( updated ( QOTProperty* ) ), otParent, SLOT ( subpropertyUpdated ( QOTProperty* ) ) );
				}
				else if ( parent->inherits ( "OpenTURNS::UI::GUI::QOTObject" ) )
				{
					QOTObject * otParent = ( QOTObject* ) parent;
					connect ( this, SIGNAL ( updated ( QOTProperty* ) ), otParent, SLOT ( propertyUpdated ( QOTProperty* ) ) );
				}

				uint level = 0;
				QOTProperty * property = this;
				while ( property->isASubproperty() )
				{
					property = ( QOTProperty* ) property->parent();
					Q_CHECK_PTR ( property );
					level++;
				}
				level_ = level;
			}

			QOTProperty::~QOTProperty()
			{
				emit destroyed ( ( QOTProperty* ) this );
			}

			QString QOTProperty::getName()
			{
				return name_;
			}

			bool QOTProperty::isASubproperty()
			{
				return parent() ->inherits ( "OpenTURNS::UI::GUI::QOTProperty" );
			}

			QOTProperty::PropertyType QOTProperty::getType() const
			{
				return type_;
			}

			void QOTProperty::setType ( const QOTProperty::PropertyType type )
			{
				type_ = type;
			}

			void QOTProperty::updatedExt()
			{
				emit updated ( this );
			}

			QOTActions QOTProperty::getActions()
			{
				QOTActions actions;
				QObjectList * childrenList = ( QObjectList* ) children();
				if ( childrenList != NULL )
				{
					for ( uint i = 0; i < childrenList->count(); i++ )
					{
						const QObject* object = childrenList->at ( i );
						if ( object->isA ( "OpenTURNS::UI::GUI::QOTAction" ) )
						{
							actions.append ( ( QOTAction* ) object );
						}
					}
				}
				return actions;
			}

			QString QOTProperty::getUuid() const
			{
				return uuid_.toString();
			}

			QOTObject* QOTProperty::getRootObject()
			{
				QOTProperty * property = this;
				while ( property->isASubproperty() )
				{
					property = ( QOTProperty* ) property->parent();
					Q_CHECK_PTR ( property );
				}
				return ( QOTObject* ) property->parent();
			}

			int QOTProperty::getRank()
			{
				QOTObject * rootObject = getRootObject();
				QOTProperties rootObjectProperties ( rootObject->getProperties ( true ) );
				for ( uint i = 0; i < rootObjectProperties.count(); i++ )
				{
					if ( rootObjectProperties.at ( i ) == this )
					{
						return i;
					}
				}
				return -1;
			}

			uint QOTProperty::getLevel() const
			{
				return level_;
			}

			QPtrList<QOTProperty> QOTProperty::getSubproperties ( bool recursiveSearch )
			{
				QPtrList<QOTProperty> properties;
				QOTProperty::getProperties ( this, &properties, recursiveSearch );
				return properties;
			}

			void QOTProperty::getProperties ( const QObject* startPoint, QPtrList<QOTProperty>* resultList, bool recursiveSearch )
			{
				QObjectList * childrenList = ( QObjectList* ) startPoint->children();
				if ( childrenList != NULL )
				{
					for ( uint i = 0; i < childrenList->count(); i++ )
					{
						const QObject* object = childrenList->at ( i );
						if ( object->inherits ( "OpenTURNS::UI::GUI::QOTProperty" ) )
						{
							resultList->append ( ( QOTProperty* ) object );
							if ( recursiveSearch )
							{
								getProperties ( object, resultList, recursiveSearch );
							}
						}
					} // for
				} // if
			}

			QStringList QOTProperty::getChoices()
			{
				return QStringList();
			}

			void QOTProperty::setDefaultChoice()
			{
				// Set first choice as default
				QStringList choices = getChoices();
				if ( choices.count() )
				{
					setValue ( choices[ 0 ] );
				}
			}

			void QOTProperty::subpropertyUpdated ( QOTProperty* subproperty )
			{
				emit updated ( subproperty );
			}

		}
	}
}
