//                                               -*- C++ -*-
/**
 * @file		QOTTitleTableItem.hxx
 * @brief		Drawing title in a QTable
 *
 * @author		Romuald Conty
 * @date			2006-07-10 14:03:55
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#include "QOTTitleTableItem.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			QOTTitleTableItem::QOTTitleTableItem ( QTable* table, QOTObject * link ) : QOTTableItem ( table, QTableItem::Never, link ), background_ ( 255, 255, 0 )
			{
			}

			QOTTitleTableItem::~QOTTitleTableItem()
			{}

			void QOTTitleTableItem::paint ( QPainter *p, const QColorGroup &cg, const QRect &cr, bool selected )
			{
				QColorGroup g ( cg );
				g.setColor ( QColorGroup::Base, background_ );
				QOTTableItem::paint ( p, g, cr, selected );
			}

			int QOTTitleTableItem::rtti () const
			{
				return 10000;
			}
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

