//                                               -*- C++ -*-
/**
 * @file		QOpenTURNS.hxx
 * @brief		Main window
 *
 * @author		Romuald Conty
 * @date		2006-06-06
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef QOPENTURNS_HXX
#define QOPENTURNS_HXX

// OT::UI::GUI
#include "Study.hxx"
#include "QConsole.hxx"

// Qt
#include <qmainwindow.h>
#include <qworkspace.h>
#include <qtable.h>
#include <qlistview.h>
#include <qaction.h>
#include <qsettings.h>

// Visual Components
#include "QStudyBrowser.hxx"
#include "QPropertiesTable.hxx"
#include "QVisualizationFrame.hxx"

/**
 * @namespace  OpenTURNS
 * @brief      The main namespace which includes all Open TURNS definitions
 */
namespace OpenTURNS
{
	/**
	 * @namespace  UI
	 * @brief      The namespace which includes all user-interface definitions
	 */

	namespace UI
	{
		/**
		 * @namespace  GUI
		 * @brief      The namespace which includes all OpenTURNS's GUI (aka QOpenTURNS) definitions
		 */

		namespace GUI
		{
			/**
			 * @class		QOpenTURNS
			 * @brief		Main window
			 *
			 * This class derived from QMainWindow create the QOpenTURNS main window
			 */

			class QOpenTURNS: public QMainWindow
			{
					Q_OBJECT

				public:

					/** Default constructor */
					QOpenTURNS();

					/** Destructor */
					virtual ~QOpenTURNS();

				protected:

					/** Create menus (on top) */
					void createMenus();
					void createStudyMenu();

					/** Create workspace */
					void createStudyWorkspace();

					/** Display confirmation dialog if study can be saved */
					void closeEvent ( QCloseEvent* );

				private slots:

					/** Create a new study */
					void newStudy();

					/** Display open dialog then open the selected study's file */
					void openStudy();

					/** Close the current study */
					void closeStudy();

					/** Save the current study */
					void saveStudy();

					/** Display save dialog then save the current study as selected filename */
					void saveStudyAs();

					/** Display the QOpenTURNS's about box */
					void about();

					/** Display the QT's about box */
					void aboutQt();

					/** wrapper to update* functions */
					void updateWindow( );

					/** Update title-bar depending on context*/
					void updateCaption( );

					/** Enable/disable each menu depending on context */
					void updateMenus();

					void showInformationAbout ( QOTObject * otObject );

					void setConsoleVisible ( bool visible );

				private:
					/** Pointer on the GUI workspace */
					QWorkspace* workspace_;

					/** */
					QSettings settings_;

					/** Pointer on "new study" action */
					QAction* actionNewStudy_;
					/** Pointer on "open study" action */
					QAction* actionOpenStudy_;
					/** Pointer on "close study" action */
					QAction* actionCloseStudy_;
					/** Pointer on "save study as" action */
					QAction* actionSaveStudyAs_;
					/** Pointer on "save study" action */
					QAction* actionSaveStudy_;

					/** Pointer on the current study */
					Study* study_;

					/** Pointer on the current study menu */
					QPopupMenu * studyMenu_;

					/** Pointer on the study's dockable window (left side) */
					QDockWindow* dockWindowStudy_;
					/** Pointer on the QStudyBrowser (left side) */
					QStudyBrowser* studyBrowser_;

					/** Pointer on the visualization's widget (centered) */
					QVisualizationFrame* visualizationFrame_;

					/** Pointer on the "console" dockable window (bottom) */
					QDockWindow* dockWindowConsole_;
					/** Pointer on the "console" */
					QConsole* console_;
			}
			; /* class QOpenTURNS */
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif /* QOPENTURNS_HXX */
