//                                               -*- C++ -*-
/**
 * @file    QPropertiesBrowserItem.cxx
 * @brief
 *
 * @author  Romuald Conty
 * @date    2007-01-09 11:22:28
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#include "QPropertiesBrowserItem.hxx"

// Qt
#include <qcanvas.h>

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			/** @class QPropertiesBrowserItem
			 */
			QPropertiesBrowserItem::QPropertiesBrowserItem ( QOTProperty * property )
			{
				property_ = property;
			}

			QPropertiesBrowserItem::~QPropertiesBrowserItem()
			{}

			QOTProperty* QPropertiesBrowserItem::getProperty()
			{
				return property_;
			}

			void QPropertiesBrowserItem::updateProperty ( const QString& value )
			{
				if ( !property_->setValue ( value ) )
				{
					this->setText ( property_->getValue() );
				}
			}


			/** @class QPropertiesBrowserNameItem
			 */
			QPropertiesBrowserNameItem::QPropertiesBrowserNameItem ( QTable* table, QOTProperty* property )
					: QWidget ( table ), QPropertiesBrowserItem ( property )
			{
				QBoxLayout * boxLayout = new QBoxLayout ( this, QBoxLayout::LeftToRight, 0, 0 );
				boxLayout->setAutoAdd ( true );

				Q_ASSERT ( boxLayout == this->layout() );

				for ( uint i = 0; i <= property->getLevel(); i++ )
				{
					QLabel* icon = new QLabel ( this );
					if ( i == property->getLevel() )
					{
						icon->setPixmap ( QPixmap::fromMimeSource ( "Property.png" ) );
						icon->setFixedSize ( 16, 26 );
					}
					else if ( i == property->getLevel() - 1 )
					{
						icon->setPixmap ( QPixmap::fromMimeSource ( "HorizontalT.png" ) );
						icon->setFixedSize ( 13, 26 );
					}
					else
					{
						icon->setPixmap ( QPixmap::fromMimeSource ( "VerticalLine.png" ) );
						icon->setFixedSize ( 13, 26 );
					}
					icon->setBackgroundMode ( Qt::PaletteBackground );
					icon->setPaletteBackgroundColor ( Qt::white );
				}

				QLabel* label = new QLabel ( property->getName(), this );
				label->setFixedHeight ( 26 );
				label->setPaletteBackgroundColor ( Qt::white );

			}

			QPropertiesBrowserNameItem::~QPropertiesBrowserNameItem()
			{}

			QString QPropertiesBrowserNameItem::getText()
			{
				return property_->getName();
			}

			void QPropertiesBrowserNameItem::setText ( const QString& text )
			{
				qDebug ( ( QString ( "QPropertiesBrowserNameItem::setText - I don't know what to do with this text : " ) + text ).ascii() );
			}


			/** @class QPropertiesBrowserComboBoxItem
			 */
			QPropertiesBrowserComboBoxItem::QPropertiesBrowserComboBoxItem ( QTable* table, QOTProperty* property )
					: QWidget ( table ), QPropertiesBrowserItem ( property )
			{
				QBoxLayout * boxLayout = new QHBoxLayout ( this, 0, 0 );
				boxLayout->setAutoAdd ( true );

				combobox_ = new QComboBox ( this );
				combobox_->setSizePolicy ( QSizePolicy ( QSizePolicy::Ignored, QSizePolicy::Ignored ) );

				combobox_->insertStringList ( property->getChoices() );
				combobox_->setCurrentText ( property->getValue() );

				connect ( combobox_, SIGNAL ( activated ( const QString & ) ), this, SLOT ( selectionChanged ( const QString & ) ) );

				connect ( property, SIGNAL ( updated() ), this, SLOT ( propertyUpdated() ) );
			}

			QPropertiesBrowserComboBoxItem::~QPropertiesBrowserComboBoxItem()
			{
				delete combobox_;
			}

			QString QPropertiesBrowserComboBoxItem::getText()
			{
				return combobox_->currentText ();
			}

			void QPropertiesBrowserComboBoxItem::setText ( const QString& text )
			{
				return combobox_->setCurrentText ( text );
			}

			void QPropertiesBrowserComboBoxItem::selectionChanged ( const QString& value )
			{
				QPropertiesBrowserItem::updateProperty ( value );
			}

			void QPropertiesBrowserComboBoxItem::propertyUpdated()
			{
				combobox_->clear();
				combobox_->insertStringList ( property_->getChoices() );
				combobox_->setCurrentText ( property_->getValue() );
			}


			/** @class QPropertiesBrowserTextItem
			 */
			QPropertiesBrowserTextItem::QPropertiesBrowserTextItem ( QTable* table, QOTProperty* property, bool editable )
					: QWidget ( table ), QPropertiesBrowserItem ( property )
			{
				QBoxLayout * boxLayout = new QHBoxLayout ( this, 0, 0 );
				boxLayout->setAutoAdd ( true );

				edit_ = new QLineEdit ( this );
				edit_->setSizePolicy ( QSizePolicy ( QSizePolicy::Ignored, QSizePolicy::Ignored ) );

				bool converted = false;
				property->getValue().toDouble ( &converted );

				if ( converted )
				{
					edit_->setAlignment ( Qt::AlignRight );
				}

				if ( !editable )
				{
					edit_->setFrameStyle ( QFrame::Panel );
					edit_->setReadOnly ( true );
				}

				edit_->setText ( property->getValue() );

				connect ( edit_, SIGNAL ( returnPressed () ), this, SLOT ( textChanged () ) );
				connect ( edit_, SIGNAL ( lostFocus () ), this, SLOT ( textChanged () ) );

				connect ( property, SIGNAL ( updated() ), this, SLOT ( propertyUpdated() ) );
			}

			QPropertiesBrowserTextItem::~QPropertiesBrowserTextItem()
			{
				delete edit_;
			}

			QString QPropertiesBrowserTextItem::getText()
			{
				return edit_->text();
			}

			void QPropertiesBrowserTextItem::setText ( const QString& text )
			{
				edit_->setText ( text );
			}

			void QPropertiesBrowserTextItem::textChanged()
			{
				QPropertiesBrowserItem::updateProperty ( edit_->text() );
			}

			void QPropertiesBrowserTextItem::propertyUpdated()
			{
				edit_->setText ( property_->getValue() );
			}
		}

	}

}
