//                                               -*- C++ -*-
/**
 * @file		QStudyBrowser.hxx
 * @brief		Browsing panel for current opened study
 *
 * @author	Romuald Conty
 * @date		2006-07-17 10:45:48
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_GUIQSTUDYBROWSER_HXX
#define OPENTURNS_GUIQSTUDYBROWSER_HXX

// Qt
#include <qwidget.h>
#include <qlistview.h>
#include <qaction.h>

// OT::UI::GUI
#include "QOTObject.hxx"

// OT::UI::GUI VisualComponents
#include "QOTItem.hxx"
#include "QOTListViewItem.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			class QStudyBrowser : public QListView
			{
					Q_OBJECT

				public:
					QStudyBrowser ( QOTObject * link, QWidget * parent, const char * name = 0 );
					~QStudyBrowser();

				public slots:
// void addItem( QOTObject * item, QOTObject * parentItem );
					void renameSelectedItem();
					void itemRenamed ( QListViewItem * item, int col, const QString & text );
					void contextMenuRequested ( QListViewItem * item, const QPoint & pos, int col );
					void childrenUpdate ( QOTListViewItem* parent );
					void remove
					( QObject * child );

				signals:
					void clicked ( QOTObject* otObject );

				protected:
					void addChildren ( QOTListViewItem * parent, QOTObject * otObject, bool recursiveAdd = false );
					void removeChildren ( QOTListViewItem * parent );

					QOTListViewItem* find ( QObject * child );

				protected slots:
					void clicked ( QListViewItem * sender );
					//, const QPoint & pos, int col );

				protected:
					/** Pointer on root item (linked with Study class) */
					QOTListViewItem * rootItem_;

					/** Pointer on the rename action */
					QAction * actionRename_;

			}
			; /* class QStudyBrowser */
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_GUIQSTUDYBROWSER_HXX */
