//                                               -*- C++ -*-
/**
 * @file		QVisualizationFrame.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-12-17 22:56:02
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#ifndef OPENTURNS_UI_GUIQVISUALIZATIONFRAME_HXX
#define OPENTURNS_UI_GUIQVISUALIZATIONFRAME_HXX

#include <qsplitter.h>

#include "QOTObject.hxx"
#include "QPropertiesTable.hxx"

#include "QPropertiesBrowser.hxx"
#include "QVisualizationTable.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			class QVisualizationFrame : public QSplitter
			{
					Q_OBJECT
				public:
					QVisualizationFrame ( QWidget *parent = 0, const char *name = 0 );

					~QVisualizationFrame();

					bool isEmpty();

				public slots:
					void visualize ( QOTObject* otObject );
					void showPropertiesAbout ( QOTObject* otObject );

				protected:
					/** Pointer on the properties' table */
					QPropertiesTable* tableProperties_;

					/** Pointer on the properties' browser */
					QPropertiesBrowser* propertiesBrowser_;

					/** Pointer on the visualization's widget (centered) */
					QVisualizationTable* visualizationTable_;

			};

		}

	}

}

#endif
