//                                               -*- C++ -*-
/**
 * @file		QVisualizationTable.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-07-10 14:38:52
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_GUIQVISUALIZATIONTABLE_HXX
#define OPENTURNS_GUIQVISUALIZATIONTABLE_HXX

// OT::UI::GUI
#include "QOTObject.hxx"

// Qt
#include <qtable.h>
#include <qaction.h>
#include <qtoolbar.h>

// Visual Component
#include "QOTTableItem.hxx"
#include "QPropertiesTable.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			class QVisualizationTable: public QTable
			{
					Q_OBJECT

				public:
					/** Default constructor */
					QVisualizationTable ( QString caption, QWidget * parent = 0, const char * name = 0 );

					/** Destructor */
					~QVisualizationTable();

					void append ( QOTObject* object, bool recursive );

					void clear();
				protected:
					void insertAt ( uint row, QOTObject* object );

					QOTTableItem* setOTTableItem ( int row, int col, const QString& text, QOTObject * otObject, bool title = false );
					QToolBar* createToolbar ( QOTObject * otObject );

					int find ( QOTObject* object );

				protected slots:
					void clicked ( int row, int col, int button, const QPoint & mousePos );

					// void duplicate( QOTObject* child );
					//void remove( QOTObject* child );
					void remove ( QOTObject* child );

					void add ( QOTObject * child );
					void update ( QOTObject* child );
				signals:
					void clicked ( QOTObject* otObject );

			};
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif
