//                                               -*- C++ -*-
/**
 * @file		Step.hxx
 * @brief		Generalization of Step*
 *
 * @author		Romuald Conty
 * @date		2006-06-12
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef OPENTURNS_GUISTEP_HXX
#define OPENTURNS_GUISTEP_HXX

// OT::UI::GUI
#include "QOTObject.hxx"

// Qt
#include <qstring.h>
#include <qaction.h>

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/**
			 * @class		Step
			 * @brief		Step class
			 *
			 * Derived from QOTObject, Step is used to derive into StepA, StepB and StepCx.
			 */

			class Step : public QOTObject
			{
					Q_OBJECT

				public:
					/** Default constructor */
					Step ( QOTObject * parent, const char * name );

					/** Destructor */
					virtual ~Step();

					virtual QString getFullName() const;

					QOTObject* chooseQOTObject ( const QString& caption, const QString& label, QObjectList* objectList );

			}
			; /* class Step */
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_GUISTEP_HXX */
