//                                               -*- C++ -*-
/**
 * @file    StrongMaximumTestProperty.cxx
 * @brief
 *
 * @author  Romuald Conty
 * @date    2007-01-14 11:47:34
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "StrongMaximumTestProperty.hxx"

// OT::UI::GUI
#include "NumericalScalarProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			StrongMaximumTestProperty::StrongMaximumTestProperty ( QObject* parent, const char* name ) : YesNoProperty ( parent, name )
			{
				enabled_ = true;
				importanceLevel_ = 0.01;
				accuracyLevel_ = 4.0;
				confidenceLevel_ = 0.95;
			}

			StrongMaximumTestProperty::~StrongMaximumTestProperty()
			{}

			bool StrongMaximumTestProperty::setValue ( QString value )
			{
				if ( value != value_ )
				{
					QOTProperties subproperties ( getSubproperties ( false ) );
					subproperties.setAutoDelete ( true );
					subproperties.clear();

					if ( value == tr ( "yes" ) )
					{
						value_ = "yes";
						enabled_ = true;
						subpropertyUpdated ( new NumericalScalarProperty ( &importanceLevel_, true, this, "importance level" ) );
						subpropertyUpdated ( new NumericalScalarProperty ( &accuracyLevel_, true, this, "accuracy level" ) );
						subpropertyUpdated ( new NumericalScalarProperty ( &confidenceLevel_, true, this, "confidence level" ) );
					}
					else if ( value == tr ( "no" ) )
					{
						value_ = "no";
						enabled_ = false;
					}
					emit ( updated() );
					return true;
				}
				return false;
			}

			bool StrongMaximumTestProperty::isEnabled() const
			{
				return enabled_;
			}

			NumericalScalar StrongMaximumTestProperty::getImportanceLevel() const
			{
				return importanceLevel_;
			}

			NumericalScalar StrongMaximumTestProperty::getAccuracyLevel() const
			{
				return accuracyLevel_;
			}

			NumericalScalar StrongMaximumTestProperty::getConfidenceLevel() const
			{
				return confidenceLevel_;
			}


		}

	}

}
