//                                               -*- C++ -*-
/**
 * @file		Study.hxx
 * @brief		Graphical representation of an OpenTURNS's Study
 *
 * @author		Romuald Conty
 * @date		2006-06-12
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef OPENTURNS_GUISTUDY_HXX
#define OPENTURNS_GUISTUDY_HXX

// OT::UI::GUI
#include "Step.hxx"
#include "StepA.hxx"
#include "StepB.hxx"
#include "StepC2.hxx"
#include "StepC3.hxx"

#include "QOTObject.hxx"

// Qt
#include <qstring.h>

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/**
			 * @class		Study
			 * @brief		Graphical representation of an OpenTURNS's Study
			 */
			class Study : public QOTObject
			{
					Q_OBJECT

				public:
					/** Default constructor */
					Study ( const char * name = 0 );

					/** Destructor */
					virtual ~Study();

					/** Study filename accessor */
					void setFilename ( const QString & filename );

					/** Study description accessor */
					QString getFilename() const;

					QString getFullName() const;

					/**
					 * @fn OpenTURNS::Bool save();
					 * @brief Save the study in a file named by filename_
					 * @return true if successfully saved, otherwise false
					 */
					bool save();

					/** Load the study contains in the file with name : filename */
					bool load ( const QString& filename );

					/** Return the modification status */
					bool isModified();

					/**
					 * @fn Step* Study::findParentStep( QListViewItem* child )
					 * @brief find the parent Step of "child"
					 * @param child a supposed Step's child in the listViewStudy_
					 * @returns parent Step if exists, NULL otherwise.
					 */
					Step* findParentStep ( QListViewItem* child );

					/**
					 * @fn StepA* Study::getStepA()
					 * @brief Study StepA accessor
					 * @returns the study's StepA.
					 */
					StepA* getStepA();

					/**
					 * @fn StepB* Study::getStepB()
					 * @brief Study StepB accessor
					 * @returns the study's StepB.
					 */
					StepB* getStepB();

					/**
					 * @fn StepC* Study::getStepC()
					 * @brief Study StepC accessor
					 * @returns the study's StepC.
					 */
					StepC2* getStepC2();

					/**
					 * @fn StepC* Study::getStepC()
					 * @brief Study StepC accessor
					 * @returns the study's StepC.
					 */
					StepC3* getStepC3();

				signals:
					/** Event invoked when the isModified_ change */
					void modifiedStateChanged ( bool newState );

				private:

					/** Study isModified_ accessor */
					void setIsModified ( bool modified );

					/** Filename (needed to load or save a study) */
					QString filename_;

					/** Modification's flag */
					bool isModified_;

					/** Pointer on the StepA */
					StepA* stepA_;

					/** Pointer on the StepB */
					StepB* stepB_;

					/** Pointer on the StepC */
					Step* stepC_;

					/** Pointer on the StepC3 */
					StepC3* stepC3_;

					/** Pointer on the StepC2 */
					StepC2* stepC2_;

			}
			; /* class Study */
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_GUISTUDY_HXX */
