//                                               -*- C++ -*-
/**
 * @file		ThresholdExceedance.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-08-28 10:29:07
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "ThresholdExceedance.hxx"

// OT::UI::GUI
#include "NumericalScalarProperty.hxx"
#include "ComparisonOperatorProperty.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{

			/** Default constructor */
			ThresholdExceedance::ThresholdExceedance ( QOTObject *parent, const char *name ) : Criterion ( parent, name )
			{
				threshold_ = 0.0;
				new NumericalScalarProperty ( &threshold_, true, this, "threshold" );

				QOTProperty* comparisonOperatorProperty = new ComparisonOperatorProperty ( &comparisonOperator_, this, "operator" );
				comparisonOperatorProperty->setDefaultChoice();
			}

			/** Copy constructor */
			ThresholdExceedance::ThresholdExceedance ( const ThresholdExceedance & other, QOTObject* parent ) : Criterion ( parent )
			{
				assignToMe ( other );
			}

			/** Destructor */
			ThresholdExceedance::~ThresholdExceedance()
			{}

			/** The function that actually realizes assignment between objects */
			void ThresholdExceedance::assignToMe ( const ThresholdExceedance & other )
			{
				Criterion::assignToMe ( other );
				threshold_ = other.getThreshold();
			}

			/** ThresholdExceedance threshold value accessor */
			NumericalScalar ThresholdExceedance::getThreshold() const
			{
				return threshold_;
			}

			ComparisonOperator ThresholdExceedance::getOperator() const
			{
				return comparisonOperator_;
			}

		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

