//                                               -*- C++ -*-
/**
 * @file		VariablesAssociationProperty.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-10 11:36:03
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "VariablesAssociationProperty.hxx"

// OT::UI::GUI
#include "EntryVariableProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			VariablesAssociationProperty::VariablesAssociationProperty ( NumericalMathFunction* numericalMathFunction, BlockA* blockA, QObject* parent, const char* name )
					: BlockFunctionProperty ( numericalMathFunction, blockA, parent, name )
			{}

			VariablesAssociationProperty::~VariablesAssociationProperty()
			{}

			QString VariablesAssociationProperty::getValue()
			{
				return BlockFunctionProperty::getValue();
			}

			bool VariablesAssociationProperty::setValue ( QString value )
			{
				return BlockFunctionProperty::setValue ( value );
			}

			void VariablesAssociationProperty::displaySubproperties()
			{
				qDebug ( "VariablesAssociationProperty::displaySubproperties()" );

				const OT::UnsignedLong inputsDimension = numericalMathFunction_->getInputNumericalPointDimension();

				inputs_ = numericalMathFunction_->getInputDescription();
				inputsProperties_.clear();
				inputVariables_ = Description ( inputsDimension );

				for ( uint i = 0; i < inputsDimension; i++ )
				{
					EntryVariableProperty* entryVariableProperty = new EntryVariableProperty ( &inputVariables_, i, blockA_, this, QString ( inputs_[ i ] ).ascii() );
					entryVariableProperty->setDefaultChoice();
					inputsProperties_.append ( entryVariableProperty );
					subpropertyUpdated ( entryVariableProperty );
				}
			}

			Description VariablesAssociationProperty::getInputVariables() const
			{
				return inputVariables_;
			}

		}

	}

}
