//                                               -*- C++ -*-
/**
 * @file		WrapperProperty.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-09 11:24:55
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "WrapperProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			WrapperProperty::WrapperProperty ( NumericalMathFunction* numericalMathFunction, QObject* parent, const char* name ) : NumericalMathFunctionProperty ( numericalMathFunction, true, parent, name )
			{}


			WrapperProperty::~WrapperProperty()
			{}

			QString WrapperProperty::getValue()
			{
				return wrapperFileName_;
			}

			bool WrapperProperty::setValue ( QString value )
			{
				if ( ( value != "" ) && ( wrapperFileName_ != value ) )
				{
					wrapperFileName_ = value;

					bool wrapperLoaded = false;
					try
					{
						NumericalMathFunction numericalMathFunction ( wrapperFileName_.ascii() );

						if ( ( numericalMathFunction.getInputNumericalPointDimension() > 0 ) &&
						        ( numericalMathFunction.getOutputNumericalPointDimension() > 0 ) )
						{
							wrapperLoaded = true;

							( *numericalMathFunction_ ) = numericalMathFunction;
							displayInputs();
							displayOutputs();
						}
					}
					catch ( ... )
					{
						wrapperLoaded = false;
					}

					if ( wrapperLoaded )
					{
						wrapperState_ = tr ( "Wrapper loaded." );
					}
					else
					{
						wrapperState_ = tr ( "Error during loading!" );
					}
					return wrapperLoaded;
				}
				return false;
			}

		}

	}

}
